"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.redirectWhenMissing = redirectWhenMissing;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _theme = require("../theme");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const ReactMarkdown = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('react-markdown'))));
const ErrorRenderer = props => /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
  fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)
}, /*#__PURE__*/_react.default.createElement(ReactMarkdown, props));
function addNotFoundToPath(path, error) {
  return path + (path.indexOf('?') >= 0 ? '&' : '?') + `notFound=${error.savedObjectType}&notFoundMessage=${error.message}`;
}

/**
 * Creates an error handler that will redirect to a url when a SavedObjectNotFound
 * error is thrown
 */
function redirectWhenMissing({
  history,
  navigateToApp,
  basePath,
  mapping,
  toastNotifications,
  onBeforeRedirect,
  theme
}) {
  let localMappingObject;
  if (typeof mapping === 'string') {
    localMappingObject = {
      '*': mapping
    };
  } else {
    localMappingObject = mapping;
  }
  return error => {
    // if this error is not "404", rethrow
    // we can't check "error instanceof SavedObjectNotFound" since this class can live in a separate bundle
    // and the error will be an instance of other class with the same interface (actually the copy of SavedObjectNotFound class)
    if (!error.savedObjectType) {
      throw error;
    }
    let redirectTarget = localMappingObject[error.savedObjectType] || localMappingObject['*'] || '/';
    if (typeof redirectTarget !== 'string') {
      redirectTarget.path = addNotFoundToPath(redirectTarget.path, error);
    } else {
      redirectTarget = addNotFoundToPath(redirectTarget, error);
    }
    toastNotifications.addWarning({
      title: _i18n.i18n.translate('kibana_utils.history.savedObjectIsMissingNotificationMessage', {
        defaultMessage: 'Saved object is missing'
      }),
      text: element => {
        _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_theme.KibanaThemeProvider, {
          theme$: theme.theme$
        }, /*#__PURE__*/_react.default.createElement(ErrorRenderer, null, error.message)), element);
        return () => _reactDom.default.unmountComponentAtNode(element);
      }
    });
    if (onBeforeRedirect) {
      onBeforeRedirect(error);
    }
    if (typeof redirectTarget !== 'string') {
      if (redirectTarget.app === 'kibana') {
        // exception for kibana app because redirect won't work right otherwise
        window.location.href = basePath.prepend(`/app/kibana${redirectTarget.path}`);
      } else {
        navigateToApp(redirectTarget.app, {
          path: redirectTarget.path
        });
      }
    } else {
      history.replace(redirectTarget);
    }
  };
}