"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaPageTemplateWithSolutionNav = exports.KibanaPageTemplateInner = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _with_solution_nav = require("./with_solution_nav");
var _util = require("./util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A thin wrapper around EuiPageTemplate with a few Kibana specific additions
 */
const KibanaPageTemplateInner = ({
  template,
  className,
  pageHeader,
  children,
  isEmptyState,
  ...rest
}) => {
  /**
   * An easy way to create the right content for empty pages
   */
  const emptyStateDefaultTemplate = 'centeredBody';
  if (isEmptyState && pageHeader && !children) {
    var _template;
    template = (_template = template) !== null && _template !== void 0 ? _template : emptyStateDefaultTemplate;
    const {
      iconType,
      pageTitle,
      description,
      rightSideItems
    } = pageHeader;
    pageHeader = undefined;
    children = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: iconType,
      iconColor: '' // This is likely a solution or app logo, so keep it multi-color
      ,
      title: pageTitle ? /*#__PURE__*/_react.default.createElement("h1", null, pageTitle) : undefined,
      body: description ? /*#__PURE__*/_react.default.createElement("p", null, description) : undefined,
      actions: rightSideItems
    });
  } else if (isEmptyState && pageHeader && children) {
    var _template2;
    template = (_template2 = template) !== null && _template2 !== void 0 ? _template2 : 'centeredContent';
  } else if (isEmptyState && !pageHeader) {
    var _template3;
    template = (_template3 = template) !== null && _template3 !== void 0 ? _template3 : emptyStateDefaultTemplate;
  }
  const classes = (0, _util.getClasses)(template, className);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate_Deprecated, (0, _extends2.default)({
    template: template,
    className: classes,
    pageHeader: pageHeader
  }, rest), children);
};
exports.KibanaPageTemplateInner = KibanaPageTemplateInner;
const KibanaPageTemplateWithSolutionNav = (0, _with_solution_nav.withSolutionNav)(KibanaPageTemplateInner);
exports.KibanaPageTemplateWithSolutionNav = KibanaPageTemplateWithSolutionNav;