"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  CodeEditor: true,
  CodeEditorField: true
};
exports.CodeEditorField = exports.CodeEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _theme = require("../theme");
var _constants = require("./languages/constants");
Object.keys(_constants).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _constants[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _constants[key];
    }
  });
});
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const LazyBaseEditor = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./code_editor'))));
const LazyCodeEditorField = /*#__PURE__*/_react.default.lazy(() => Promise.resolve().then(() => _interopRequireWildcard(require('./code_editor_field'))).then(m => ({
  default: m.CodeEditorField
})));
const Fallback = ({
  height
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    style: height ? {
      minHeight: height
    } : {}
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDelayRender, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3
  }))));
};
/**
 * Renders a Monaco code editor with EUI color theme.
 *
 * @see CodeEditorField to render a code editor in the same style as other EUI form fields.
 */
const CodeEditor = props => {
  const coreTheme = (0, _theme.useKibanaTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(Fallback, {
      height: props.height
    })
  }, /*#__PURE__*/_react.default.createElement(LazyBaseEditor, (0, _extends2.default)({}, props, {
    useDarkTheme: coreTheme.darkMode
  }))));
};

/**
 * Renders a Monaco code editor in the same style as other EUI form fields.
 */
exports.CodeEditor = CodeEditor;
const CodeEditorField = props => {
  const coreTheme = (0, _theme.useKibanaTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.default.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(Fallback, {
      height: props.height
    })
  }, /*#__PURE__*/_react.default.createElement(LazyCodeEditorField, (0, _extends2.default)({}, props, {
    useDarkTheme: coreTheme.darkMode
  }))));
};
exports.CodeEditorField = CodeEditorField;