"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "METRIC_TYPE", {
  enumerable: true,
  get: function () {
    return _analytics.METRIC_TYPE;
  }
});
exports.init = init;
exports.reportUiCounter = void 0;
exports.trackUiMetric = trackUiMetric;
var _analytics = require("@kbn/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let reportUiCounter;
exports.reportUiCounter = reportUiCounter;
function init(_reportUiCounter) {
  exports.reportUiCounter = reportUiCounter = _reportUiCounter;
}
function trackUiMetric(metricType, name) {
  if (!reportUiCounter) {
    return;
  }
  reportUiCounter('kibana_overview', metricType, name);
}