"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RequestsViewComponent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _adapters = require("../../../../common/adapters");
var _request_selector = require("./request_selector");
var _request_details = require("./request_details");
var _disambiguate_request_names = require("./disambiguate_request_names");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class RequestsViewComponent extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_onRequestsChange", () => {
      const requests = this.getRequests();
      const newState = {
        requests
      };
      if (!this.state.request || !requests.includes(this.state.request)) {
        newState.request = requests.length ? requests[0] : null;
      }
      this.setState(newState);
    });
    (0, _defineProperty2.default)(this, "selectRequest", request => {
      if (request !== this.state.request) {
        this.setState({
          request
        });
      }
    });
    props.adapters.requests.on('change', this._onRequestsChange);
    const _requests = this.getRequests();
    this.state = {
      requests: _requests,
      request: _requests.length ? _requests[0] : null
    };
  }
  getRequests() {
    return (0, _disambiguate_request_names.disambiguateRequestNames)(this.props.adapters.requests.getRequests());
  }
  componentWillUnmount() {
    this.props.adapters.requests.removeListener('change', this._onRequestsChange);
  }
  static renderEmptyRequests() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "inspectorNoRequestsMessage",
      title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.noRequestsLoggedTitle",
        defaultMessage: "No requests logged"
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.noRequestsLoggedDescription.elementHasNotLoggedAnyRequestsText",
        defaultMessage: "The element hasn't logged any requests (yet)."
      })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "inspector.requests.noRequestsLoggedDescription.whatDoesItUsuallyMeanText",
        defaultMessage: "This usually means that there was no need to fetch any data or that the element has not yet started fetching data."
      })))
    });
  }
  render() {
    if (!this.state.requests || !this.state.requests.length) {
      return RequestsViewComponent.renderEmptyRequests();
    }
    const failedCount = this.state.requests.filter(req => req.status === _adapters.RequestStatus.ERROR).length;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", {
      role: "status",
      "aria-live": "polite",
      "aria-atomic": "true"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inspector.requests.requestWasMadeDescription",
      defaultMessage: "{requestsCount, plural, one {# request was} other {# requests were} } made{failedRequests}",
      values: {
        requestsCount: this.state.requests.length,
        failedRequests: failedCount > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "danger"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "inspector.requests.requestWasMadeDescription.requestHadFailureText",
          defaultMessage: ", {failedCount} had a failure",
          values: {
            failedCount
          }
        })) : ''
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), this.state.request && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_request_selector.RequestSelector, {
      requests: this.state.requests,
      selectedRequest: this.state.request,
      onRequestChanged: this.selectRequest
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    })), this.state.request && this.state.request.description && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", null, this.state.request.description)), this.state.request && this.state.request.searchSessionId && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": 'inspectorRequestSearchSessionId',
      "data-search-session-id": this.state.request.searchSessionId
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inspector.requests.searchSessionId",
      defaultMessage: "Search session id: {searchSessionId}",
      values: {
        searchSessionId: this.state.request.searchSessionId
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), this.state.request && /*#__PURE__*/_react.default.createElement(_request_details.RequestDetails, {
      request: this.state.request
    }));
  }
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = exports.RequestsViewComponent = RequestsViewComponent;
(0, _defineProperty2.default)(RequestsViewComponent, "propTypes", {
  adapters: _propTypes.default.object.isRequired,
  title: _propTypes.default.string.isRequired
});