"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestDetails = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _details = require("./details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DETAILS = [{
  name: 'Statistics',
  label: _i18n.i18n.translate('inspector.requests.statisticsTabLabel', {
    defaultMessage: 'Statistics'
  }),
  component: _details.RequestDetailsStats
}, {
  name: 'Request',
  label: _i18n.i18n.translate('inspector.requests.requestTabLabel', {
    defaultMessage: 'Request'
  }),
  component: _details.RequestDetailsRequest
}, {
  name: 'Response',
  label: _i18n.i18n.translate('inspector.requests.responseTabLabel', {
    defaultMessage: 'Response'
  }),
  component: _details.RequestDetailsResponse
}];
class RequestDetails extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      availableDetails: [],
      selectedDetail: null
    });
    (0, _defineProperty2.default)(this, "selectDetailsTab", detail => {
      if (detail !== this.state.selectedDetail) {
        this.setState({
          selectedDetail: detail
        });
      }
    });
    (0, _defineProperty2.default)(this, "renderDetailTab", detail => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        key: detail.name,
        isSelected: detail === this.state.selectedDetail,
        onClick: () => this.selectDetailsTab(detail),
        "data-test-subj": `inspectorRequestDetail${detail.name}`
      }, detail.label);
    });
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    const selectedDetail = prevState && prevState.selectedDetail;
    const availableDetails = DETAILS.filter(detail => !detail.component.shouldShow || detail.component.shouldShow(nextProps.request));
    // If the previously selected detail is still available we want to stay
    // on this tab and not set another selectedDetail.
    if (selectedDetail && availableDetails.includes(selectedDetail)) {
      return {
        availableDetails
      };
    }
    return {
      availableDetails,
      selectedDetail: availableDetails[0]
    };
  }
  static getSelectedDetailComponent(detail) {
    return detail ? detail.component : null;
  }
  render() {
    const {
      selectedDetail,
      availableDetails
    } = this.state;
    const DetailComponent = RequestDetails.getSelectedDetailComponent(selectedDetail);
    if (!availableDetails.length || !DetailComponent) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
      size: "s"
    }, this.state.availableDetails.map(this.renderDetailTab)), /*#__PURE__*/_react.default.createElement(DetailComponent, {
      request: this.props.request
    }));
  }
}
exports.RequestDetails = RequestDetails;
(0, _defineProperty2.default)(RequestDetails, "propTypes", {
  request: _propTypes.default.object.isRequired
});