"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInputControlVisTypeDefinition = createInputControlVisTypeDefinition;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/visualizations-plugin/public");
var _editor = require("./components/editor");
var _to_ast = require("./to_ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function createInputControlVisTypeDefinition(deps, readOnly) {
  const ControlsTab = (0, _editor.getControlsTab)(deps);
  return {
    name: 'input_control_vis',
    title: _i18n.i18n.translate('inputControl.register.controlsTitle', {
      defaultMessage: 'Input controls'
    }),
    icon: 'controlsHorizontal',
    group: _public.VisGroups.TOOLS,
    description: _i18n.i18n.translate('inputControl.register.controlsDescription', {
      defaultMessage: 'Input controls are deprecated and will be removed in a future version.'
    }),
    stage: 'experimental',
    disableCreate: true,
    // input controls are deprecated and input control creation has been permanently disabled
    disableEdit: readOnly,
    isDeprecated: true,
    visConfig: {
      defaults: {
        controls: [],
        updateFiltersOnChange: false,
        useTimeFilter: false,
        pinFilters: false
      }
    },
    editorConfig: {
      optionTabs: [{
        name: 'controls',
        title: _i18n.i18n.translate('inputControl.register.tabs.controlsTitle', {
          defaultMessage: 'Controls'
        }),
        editor: ControlsTab
      }, {
        name: 'options',
        title: _i18n.i18n.translate('inputControl.register.tabs.optionsTitle', {
          defaultMessage: 'Options'
        }),
        editor: _editor.OptionsTabLazy
      }]
    },
    inspectorAdapters: {},
    toExpressionAst: _to_ast.toExpressionAst
  };
}