"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _control_editor = require("./control_editor");
var _editor_utils = require("../../editor_utils");
var _lineage = require("../../lineage");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ControlsTab extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      type: _editor_utils.CONTROL_TYPES.LIST
    });
    (0, _defineProperty2.default)(this, "getIndexPattern", async indexPatternId => {
      const [, startDeps] = await this.props.deps.core.getStartServices();
      return await startDeps.data.indexPatterns.get(indexPatternId);
    });
    (0, _defineProperty2.default)(this, "onChange", value => this.props.setValue('controls', value));
    (0, _defineProperty2.default)(this, "handleLabelChange", (controlIndex, label) => {
      const updatedControl = {
        ...this.props.stateParams.controls[controlIndex],
        label
      };
      this.onChange((0, _editor_utils.setControl)(this.props.stateParams.controls, controlIndex, updatedControl));
    });
    (0, _defineProperty2.default)(this, "handleIndexPatternChange", (controlIndex, indexPattern) => {
      const updatedControl = {
        ...this.props.stateParams.controls[controlIndex],
        indexPattern,
        fieldName: ''
      };
      this.onChange((0, _editor_utils.setControl)(this.props.stateParams.controls, controlIndex, updatedControl));
    });
    (0, _defineProperty2.default)(this, "handleFieldNameChange", (controlIndex, fieldName) => {
      const updatedControl = {
        ...this.props.stateParams.controls[controlIndex],
        fieldName
      };
      this.onChange((0, _editor_utils.setControl)(this.props.stateParams.controls, controlIndex, updatedControl));
    });
    (0, _defineProperty2.default)(this, "handleOptionsChange", (controlIndex, optionName, value) => {
      const control = this.props.stateParams.controls[controlIndex];
      const updatedControl = {
        ...control,
        options: {
          ...control.options,
          [optionName]: value
        }
      };
      this.onChange((0, _editor_utils.setControl)(this.props.stateParams.controls, controlIndex, updatedControl));
    });
    (0, _defineProperty2.default)(this, "handleRemoveControl", controlIndex => {
      this.onChange((0, _editor_utils.removeControl)(this.props.stateParams.controls, controlIndex));
    });
    (0, _defineProperty2.default)(this, "moveControl", (controlIndex, direction) => {
      this.onChange((0, _editor_utils.moveControl)(this.props.stateParams.controls, controlIndex, direction));
    });
    (0, _defineProperty2.default)(this, "handleAddControl", () => {
      this.onChange((0, _editor_utils.addControl)(this.props.stateParams.controls, (0, _editor_utils.newControl)(this.state.type)));
    });
    (0, _defineProperty2.default)(this, "handleParentChange", (controlIndex, parent) => {
      const updatedControl = {
        ...this.props.stateParams.controls[controlIndex],
        parent
      };
      this.onChange((0, _editor_utils.setControl)(this.props.stateParams.controls, controlIndex, updatedControl));
    });
  }
  renderControls() {
    const lineageMap = (0, _lineage.getLineageMap)(this.props.stateParams.controls);
    return this.props.stateParams.controls.map((controlParams, controlIndex) => {
      const parentCandidates = (0, _lineage.getParentCandidates)(this.props.stateParams.controls, controlParams.id, lineageMap);
      return /*#__PURE__*/_react.default.createElement(_control_editor.ControlEditor, {
        key: controlParams.id,
        controlIndex: controlIndex,
        controlParams: controlParams,
        handleLabelChange: this.handleLabelChange,
        moveControl: this.moveControl,
        handleRemoveControl: this.handleRemoveControl,
        handleIndexPatternChange: this.handleIndexPatternChange,
        handleFieldNameChange: this.handleFieldNameChange,
        getIndexPattern: this.getIndexPattern,
        handleOptionsChange: this.handleOptionsChange,
        parentCandidates: parentCandidates,
        handleParentChange: this.handleParentChange,
        deps: this.props.deps
      });
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", null, this.renderControls(), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "selectControlType"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      "data-test-subj": "selectControlType",
      options: [{
        value: _editor_utils.CONTROL_TYPES.RANGE,
        text: _i18n.i18n.translate('inputControl.editor.controlsTab.select.rangeDropDownOptionLabel', {
          defaultMessage: 'Range slider'
        })
      }, {
        value: _editor_utils.CONTROL_TYPES.LIST,
        text: _i18n.i18n.translate('inputControl.editor.controlsTab.select.listDropDownOptionLabel', {
          defaultMessage: 'Options list'
        })
      }],
      value: this.state.type,
      onChange: event => this.setState({
        type: event.target.value
      }),
      "aria-label": _i18n.i18n.translate('inputControl.editor.controlsTab.select.controlTypeAriaLabel', {
        defaultMessage: 'Select control type'
      })
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "addControl"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      onClick: this.handleAddControl,
      iconType: "plusInCircle",
      "data-test-subj": "inputControlEditorAddBtn",
      "aria-label": _i18n.i18n.translate('inputControl.editor.controlsTab.select.addControlAriaLabel', {
        defaultMessage: 'Add control'
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "inputControl.editor.controlsTab.addButtonLabel",
      defaultMessage: "Add"
    })))))));
  }
}

// default export required for React.Lazy
// eslint-disable-next-line import/no-default-export
exports.default = ControlsTab;
module.exports = exports.default;