"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineFormError = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../shared_imports");
var _i18n_texts = require("./i18n_texts");
var _error_utils = require("./error_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const numberOfErrorsToDisplay = 5;
const PipelineFormError = ({
  error
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const [isShowingAllErrors, setIsShowingAllErrors] = (0, _react.useState)(false);
  const safeErrorResult = (0, _error_utils.toKnownError)(error);
  const hasMoreErrors = safeErrorResult.errors.length > numberOfErrorsToDisplay;
  const hiddenErrorsCount = safeErrorResult.errors.length - numberOfErrorsToDisplay;
  const results = isShowingAllErrors ? safeErrorResult.errors : safeErrorResult.errors.slice(0, numberOfErrorsToDisplay);
  const renderErrorListItem = ({
    processorType,
    reason
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, processorType ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n_texts.i18nTexts.errors.processor(processorType) + ':', "\xA0") : undefined, reason);
  };
  (0, _react.useEffect)(() => {
    services.notifications.toasts.addDanger({
      title: _i18n_texts.i18nTexts.title
    });
  }, [services, error]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n_texts.i18nTexts.title,
    color: "danger",
    iconType: "warning",
    "data-test-subj": "savePipelineError"
  }, results.length > 1 ? /*#__PURE__*/_react.default.createElement("ul", null, results.map((e, idx) => /*#__PURE__*/_react.default.createElement("li", {
    key: idx
  }, renderErrorListItem(e)))) : renderErrorListItem(results[0]), hasMoreErrors ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "xs",
    justifyContent: "center",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isShowingAllErrors ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => setIsShowingAllErrors(false),
    color: "danger",
    iconSide: "right",
    iconType: "arrowUp",
    "data-test-subj": "hideErrorsButton"
  }, _i18n_texts.i18nTexts.errors.hideErrors(hiddenErrorsCount)) : /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => setIsShowingAllErrors(true),
    color: "danger",
    iconSide: "right",
    iconType: "arrowDown",
    "data-test-subj": "showErrorsButton"
  }, _i18n_texts.i18nTexts.errors.showErrors(hiddenErrorsCount)))) : undefined), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.PipelineFormError = PipelineFormError;