"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProcessorTypesAndLabels = exports.extractProcessorDetails = exports.ProcessorTypeField = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _function = require("fp-ts/lib/function");
var _Array = require("fp-ts/lib/Array");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _shared_imports = require("../../../../../../../shared_imports");
var _shared = require("../../../shared");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractProcessorDetails = (0, _function.flow)(Object.entries, (0, _Array.map)(([type, {
  label,
  forLicenseAtLeast
}]) => ({
  label,
  value: type,
  ...(forLicenseAtLeast ? {
    forLicenseAtLeast
  } : {})
})), arr => arr.sort((a, b) => a.label.localeCompare(b.label)));
exports.extractProcessorDetails = extractProcessorDetails;
const getProcessorTypesAndLabels = license => {
  return extractProcessorDetails(_shared.mapProcessorTypeToDescriptor)
  // Filter out any processors that are not available for the current license type
  .filter(option => {
    return option.forLicenseAtLeast ? license === null || license === void 0 ? void 0 : license.hasAtLeast(option.forLicenseAtLeast) : true;
  })
  // Convert to EuiComboBox options
  .map(({
    value,
    label
  }) => ({
    label,
    value
  }));
};
exports.getProcessorTypesAndLabels = getProcessorTypesAndLabels;
const {
  emptyField
} = _shared_imports.fieldValidators;
const typeConfig = {
  type: _shared_imports.FIELD_TYPES.COMBO_BOX,
  label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.typeField.typeFieldLabel', {
    defaultMessage: 'Processor'
  }),
  deserializer: String,
  validations: [{
    validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.typeField.fieldRequiredError', {
      defaultMessage: 'A type is required.'
    }))
  }]
};
const ProcessorTypeField = ({
  initialType
}) => {
  const {
    services: {
      documentation,
      license
    }
  } = (0, _shared_imports.useKibana)();
  const esDocUrl = documentation.getEsDocsBasePath();
  // Some processors are only available for certain license types
  const processorOptions = (0, _react.useMemo)(() => getProcessorTypesAndLabels(license), [license]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: typeConfig,
    defaultValue: initialType,
    path: "type"
  }, typeField => {
    var _typeField$value;
    let selectedOptions;
    let description = '';
    if ((_typeField$value = typeField.value) !== null && _typeField$value !== void 0 && _typeField$value.length) {
      const type = typeField.value;
      const processorDescriptor = (0, _shared.getProcessorDescriptor)(type);
      if (processorDescriptor) {
        description = processorDescriptor.typeDescription || '';
        selectedOptions = [{
          label: processorDescriptor.label,
          value: type
        }];
      } else {
        // If there is no label for this processor type, just use the type as the label
        selectedOptions = [{
          label: type,
          value: type
        }];
      }
    } else {
      selectedOptions = [];
    }
    const error = typeField.getErrorsMessages();
    const isInvalid = error ? Boolean(error.length) : false;
    const onCreateComboOption = value => {
      // Note: for now, all validations for a comboBox array item have to be synchronous
      // If there is a need to support asynchronous validation, we'll work on it (and will need to update the <EuiComboBox /> logic).
      const {
        isValid
      } = typeField.validate({
        value,
        validationType: _hook_form_lib.VALIDATION_TYPES.ARRAY_ITEM
      });
      if (!isValid) {
        // Return false to explicitly reject the user's input.
        return false;
      }
      typeField.setValue(value);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: typeField.label,
      labelAppend: typeField.labelAppend,
      helpText: typeof description === 'function' ? description(esDocUrl) : description,
      error: error,
      isInvalid: isInvalid,
      fullWidth: true,
      "data-test-subj": "processorTypeSelector"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      fullWidth: true,
      placeholder: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.typeField.typeFieldComboboxPlaceholder', {
        defaultMessage: 'Type and then hit "ENTER"'
      }),
      options: processorOptions,
      selectedOptions: selectedOptions,
      onCreateOption: onCreateComboOption,
      onChange: options => {
        var _ref;
        const [selection] = options;
        typeField.setValue((_ref = selection === null || selection === void 0 ? void 0 : selection.value) !== null && _ref !== void 0 ? _ref : '');
      },
      noSuggestions: false,
      singleSelection: {
        asPlainText: true
      },
      "data-test-subj": "input"
    }));
  });
};
exports.ProcessorTypeField = ProcessorTypeField;