"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaUiSetting = useKibanaUiSetting;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useKibanaUiSetting(key, defaultValue) {
  const [uiSetting, setUiSetting] = (0, _public.useUiSetting$)(key);
  const uiSettingValue = (0, _react.useMemo)(() => {
    return uiSetting ? uiSetting : defaultValue;
  }, [uiSetting, defaultValue]);
  return [uiSettingValue, setUiSetting];
}