"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InventoryViewsClient = void 0;
var _latest = require("../../../common/http_api/latest");
var _inventory_views = require("../../../common/inventory_views");
var _runtime_types = require("../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InventoryViewsClient {
  constructor(http) {
    this.http = http;
  }
  async findInventoryViews() {
    const response = await this.http.get((0, _latest.getInventoryViewUrl)()).catch(error => {
      throw new _inventory_views.FetchInventoryViewError(`Failed to fetch inventory views: ${error}`);
    });
    const {
      data
    } = (0, _runtime_types.decodeOrThrow)(_latest.findInventoryViewResponsePayloadRT, message => new _inventory_views.FetchInventoryViewError(`Failed to decode inventory views: ${message}"`))(response);
    return data;
  }
  async getInventoryView(inventoryViewId) {
    const response = await this.http.get((0, _latest.getInventoryViewUrl)(inventoryViewId)).catch(error => {
      throw new _inventory_views.FetchInventoryViewError(`Failed to fetch inventory view "${inventoryViewId}": ${error}`);
    });
    const {
      data
    } = (0, _runtime_types.decodeOrThrow)(_latest.inventoryViewResponsePayloadRT, message => new _inventory_views.FetchInventoryViewError(`Failed to decode inventory view "${inventoryViewId}": ${message}"`))(response);
    return data;
  }
  async createInventoryView(inventoryViewAttributes) {
    const response = await this.http.post((0, _latest.getInventoryViewUrl)(), {
      body: JSON.stringify(_latest.createInventoryViewRequestPayloadRT.encode({
        attributes: inventoryViewAttributes
      }))
    }).catch(error => {
      var _error$body$message, _error$body;
      throw new _inventory_views.UpsertInventoryViewError(`Failed to create new inventory view: ${(_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message}`);
    });
    const {
      data
    } = (0, _runtime_types.decodeOrThrow)(_latest.inventoryViewResponsePayloadRT, message => new _inventory_views.UpsertInventoryViewError(`Failed to decode newly written inventory view: ${message}"`))(response);
    return data;
  }
  async updateInventoryView(inventoryViewId, inventoryViewAttributes) {
    const response = await this.http.put((0, _latest.getInventoryViewUrl)(inventoryViewId), {
      body: JSON.stringify(_latest.createInventoryViewRequestPayloadRT.encode({
        attributes: inventoryViewAttributes
      }))
    }).catch(error => {
      var _error$body$message2, _error$body2;
      throw new _inventory_views.UpsertInventoryViewError(`Failed to update inventory view "${inventoryViewId}": ${(_error$body$message2 = (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message) !== null && _error$body$message2 !== void 0 ? _error$body$message2 : error.message}`);
    });
    const {
      data
    } = (0, _runtime_types.decodeOrThrow)(_latest.inventoryViewResponsePayloadRT, message => new _inventory_views.UpsertInventoryViewError(`Failed to decode updated inventory view "${inventoryViewId}": ${message}"`))(response);
    return data;
  }
  deleteInventoryView(inventoryViewId) {
    return this.http.delete((0, _latest.getInventoryViewUrl)(inventoryViewId)).then(() => null).catch(error => {
      throw new _inventory_views.DeleteInventoryViewError(`Failed to delete inventory view "${inventoryViewId}": ${error}`);
    });
  }
}
exports.InventoryViewsClient = InventoryViewsClient;