"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _empty_states = require("../../components/empty_states");
var _use_kibana = require("../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsPageTemplate = ({
  hasData = true,
  'data-test-subj': _dataTestSubj,
  ...pageTemplateProps
}) => {
  const {
    services: {
      observabilityShared: {
        navigation: {
          PageTemplate
        }
      },
      docLinks
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const noDataConfig = hasData ? undefined : {
    solution: _i18n.i18n.translate('xpack.infra.metrics.noDataConfig.solutionName', {
      defaultMessage: 'Observability'
    }),
    action: {
      beats: {
        title: _empty_states.noMetricIndicesPromptPrimaryActionTitle,
        description: _empty_states.noMetricIndicesPromptDescription
      }
    },
    docsLink: docLinks.links.observability.guide
  };
  return /*#__PURE__*/_react.default.createElement(PageTemplate, (0, _extends2.default)({
    "data-test-subj": hasData ? _dataTestSubj : 'noDataPage',
    noDataConfig: noDataConfig
  }, pageTemplateProps));
};
exports.MetricsPageTemplate = MetricsPageTemplate;