"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerChartOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_metrics_explorer_options = require("../hooks/use_metrics_explorer_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsExplorerChartOptions = ({
  chartOptions,
  onChange
}) => {
  const [isPopoverOpen, setPopoverState] = (0, _react.useState)(false);
  const handleClosePopover = (0, _react.useCallback)(() => {
    setPopoverState(false);
  }, []);
  const handleOpenPopover = (0, _react.useCallback)(() => {
    setPopoverState(true);
  }, []);
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "left",
    iconType: "eye",
    onClick: handleOpenPopover,
    "data-test-subj": "metricsExplorer-customize"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metricsExplorer.customizeChartOptions",
    defaultMessage: "Customize"
  }));
  const yAxisRadios = [{
    id: _use_metrics_explorer_options.MetricsExplorerYAxisMode.auto,
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.autoLabel', {
      defaultMessage: 'Automatic (min to max)'
    })
  }, {
    id: _use_metrics_explorer_options.MetricsExplorerYAxisMode.fromZero,
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.fromZeroLabel', {
      defaultMessage: 'From zero (0 to max)'
    })
  }];
  const typeRadios = [{
    'data-test-subj': 'metricsExplorer-chartRadio-line',
    id: _use_metrics_explorer_options.MetricsExplorerChartType.line,
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.lineLabel', {
      defaultMessage: 'Line'
    })
  }, {
    'data-test-subj': 'metricsExplorer-chartRadio-area',
    id: _use_metrics_explorer_options.MetricsExplorerChartType.area,
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.areaLabel', {
      defaultMessage: 'Area'
    })
  }, {
    'data-test-subj': 'metricsExplorer-chartRadio-bar',
    id: _use_metrics_explorer_options.MetricsExplorerChartType.bar,
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.barLabel', {
      defaultMessage: 'Bar'
    })
  }];
  const handleYAxisChange = (0, _react.useCallback)(id => {
    onChange({
      ...chartOptions,
      yAxisMode: id
    });
  }, [chartOptions, onChange]);
  const handleTypeChange = (0, _react.useCallback)(id => {
    onChange({
      ...chartOptions,
      type: id
    });
  }, [chartOptions, onChange]);
  const handleStackChange = (0, _react.useCallback)(e => {
    onChange({
      ...chartOptions,
      stack: e.target.checked
    });
  }, [chartOptions, onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "MetricExplorerChartOptionsPopover",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: handleClosePopover
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.typeLabel', {
      defaultMessage: 'Chart style'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    "data-test-subj": "infraMetricsExplorerChartOptionsRadioGroup",
    compressed: true,
    options: typeRadios,
    idSelected: chartOptions.type,
    onChange: handleTypeChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.stackLabel', {
      defaultMessage: 'Stack series'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.stackSwitchLabel', {
      defaultMessage: 'Stack'
    }),
    checked: chartOptions.stack,
    onChange: handleStackChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    label: _i18n.i18n.translate('xpack.infra.metricsExplorer.chartOptions.yAxisDomainLabel', {
      defaultMessage: 'Y Axis Domain'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    "data-test-subj": "infraMetricsExplorerChartOptionsRadioGroup",
    compressed: true,
    options: yAxisRadios,
    idSelected: chartOptions.yAxisMode,
    onChange: handleYAxisChange
  }))));
};
exports.MetricsExplorerChartOptions = MetricsExplorerChartOptions;