"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Section = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _side_nav_context = require("../lib/side_nav_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Section = ({
  children,
  metrics,
  navLabel,
  sectionLabel,
  onChangeRangeTime,
  isLiveStreaming,
  stopLiveStreaming
}) => {
  const {
    addNavItem
  } = (0, _react.useContext)(_side_nav_context.SideNavContext);
  const subNavItems = _react.Children.toArray(children).reduce((accumulatedChildren, child) => {
    var _metrics$find;
    if (! /*#__PURE__*/(0, _react.isValidElement)(child)) {
      return accumulatedChildren;
    }
    const metric = (_metrics$find = metrics === null || metrics === void 0 ? void 0 : metrics.find(m => m.id === child.props.id)) !== null && _metrics$find !== void 0 ? _metrics$find : null;
    if (metric === null) {
      return accumulatedChildren;
    }
    if (!child.props.label) {
      return accumulatedChildren;
    }
    return [...accumulatedChildren, {
      id: child.props.id,
      name: child.props.label,
      onClick: () => {
        const el = document.getElementById(child.props.id);
        if (el) {
          el.scrollIntoView();
        }
      }
    }];
  }, []);
  const childrenWithProps = _react.Children.map(children, child => /*#__PURE__*/(0, _react.isValidElement)(child) ? /*#__PURE__*/(0, _react.cloneElement)(child, {
    metrics,
    onChangeRangeTime,
    isLiveStreaming,
    stopLiveStreaming
  }) : null);
  if (metrics && subNavItems.length) {
    addNavItem({
      id: navLabel,
      name: navLabel,
      items: subNavItems
    });
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h1", null, sectionLabel)), childrenWithProps);
  }
  return null;
};
exports.Section = Section;