"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProcessListRowChart = useProcessListRowChart;
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _react = require("react");
var _http_api = require("../../../../../common/http_api");
var _runtime_types = require("../../../../../common/runtime_types");
var _use_http_request = require("../../../../hooks/use_http_request");
var _use_process_list = require("./use_process_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProcessListRowChart(command) {
  const [inErrorState, setInErrorState] = (0, _react.useState)(false);
  const decodeResponse = response => {
    return (0, _pipeable.pipe)(_http_api.ProcessListAPIChartResponseRT.decode(response), (0, _Either.fold)((0, _runtime_types.throwErrors)(_runtime_types.createPlainError), _function.identity));
  };
  const {
    hostTerm,
    indexPattern,
    to
  } = (0, _use_process_list.useProcessListContext)();
  const {
    error,
    loading,
    response,
    makeRequest
  } = (0, _use_http_request.useHTTPRequest)('/api/metrics/process_list/chart', 'POST', JSON.stringify({
    hostTerm,
    indexPattern,
    to,
    command
  }), decodeResponse);
  (0, _react.useEffect)(() => setInErrorState(true), [error]);
  (0, _react.useEffect)(() => setInErrorState(false), [loading]);
  (0, _react.useEffect)(() => {
    makeRequest();
  }, [makeRequest]);
  return {
    error: inErrorState,
    loading,
    response,
    makeRequest
  };
}