"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessListContextProvider = void 0;
exports.useProcessList = useProcessList;
exports.useProcessListContext = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _pipeable = require("fp-ts/lib/pipeable");
var _react = require("react");
var _http_api = require("../../../../../common/http_api");
var _runtime_types = require("../../../../../common/runtime_types");
var _use_http_request = require("../../../../hooks/use_http_request");
var _metrics_source = require("../../../../containers/metrics_source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProcessList(hostTerm, to, sortBy, searchFilter) {
  const {
    createDerivedIndexPattern
  } = (0, _metrics_source.useSourceContext)();
  const indexPattern = createDerivedIndexPattern().title;
  const decodeResponse = response => {
    return (0, _pipeable.pipe)(_http_api.ProcessListAPIResponseRT.decode(response), (0, _Either.fold)((0, _runtime_types.throwErrors)(_runtime_types.createPlainError), _function.identity));
  };
  const parsedSortBy = sortBy.name === 'runtimeLength' ? {
    ...sortBy,
    name: 'startTime'
  } : sortBy;
  const {
    error,
    loading,
    response,
    makeRequest
  } = (0, _use_http_request.useHTTPRequest)('/api/metrics/process_list', 'POST', JSON.stringify({
    hostTerm,
    indexPattern,
    to,
    sortBy: parsedSortBy,
    searchFilter
  }), decodeResponse);
  (0, _react.useEffect)(() => {
    makeRequest();
  }, [makeRequest]);
  return {
    error: error && error.message || null,
    loading,
    response,
    makeRequest
  };
}
function useProcessListParams(props) {
  const {
    hostTerm,
    to
  } = props;
  const {
    createDerivedIndexPattern
  } = (0, _metrics_source.useSourceContext)();
  const indexPattern = createDerivedIndexPattern().title;
  return {
    hostTerm,
    indexPattern,
    to
  };
}
const ProcessListContext = (0, _constate.default)(useProcessListParams);
const [ProcessListContextProvider, useProcessListContext] = ProcessListContext;
exports.useProcessListContext = useProcessListContext;
exports.ProcessListContextProvider = ProcessListContextProvider;