"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaffleInventorySwitcher = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _inventory_models = require("../../../../../../common/inventory_models");
var _use_waffle_options = require("../../hooks/use_waffle_options");
var _dropdown_button = require("../dropdown_button");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDisplayNameForType = type => {
  const inventoryModel = (0, _inventory_models.findInventoryModel)(type);
  return inventoryModel.displayName;
};
const WaffleInventorySwitcher = () => {
  const {
    changeNodeType,
    changeGroupBy,
    changeMetric,
    changeAccount,
    changeRegion,
    changeCustomMetrics,
    nodeType
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const closePopover = (0, _react.useCallback)(() => setIsOpen(false), []);
  const openPopover = (0, _react.useCallback)(() => setIsOpen(true), []);
  const goToNodeType = (0, _react.useCallback)(targetNodeType => {
    closePopover();
    changeNodeType(targetNodeType);
    changeGroupBy([]);
    changeCustomMetrics([]);
    changeAccount('');
    changeRegion('');
    const inventoryModel = (0, _inventory_models.findInventoryModel)(targetNodeType);
    changeMetric({
      type: inventoryModel.metrics.defaultSnapshot
    });
  }, [closePopover, changeNodeType, changeGroupBy, changeCustomMetrics, changeAccount, changeRegion, changeMetric]);
  const goToHost = (0, _react.useCallback)(() => goToNodeType('host'), [goToNodeType]);
  const goToK8 = (0, _react.useCallback)(() => goToNodeType('pod'), [goToNodeType]);
  const goToDocker = (0, _react.useCallback)(() => goToNodeType('container'), [goToNodeType]);
  const goToAwsEC2 = (0, _react.useCallback)(() => goToNodeType('awsEC2'), [goToNodeType]);
  const goToAwsS3 = (0, _react.useCallback)(() => goToNodeType('awsS3'), [goToNodeType]);
  const goToAwsRDS = (0, _react.useCallback)(() => goToNodeType('awsRDS'), [goToNodeType]);
  const goToAwsSQS = (0, _react.useCallback)(() => goToNodeType('awsSQS'), [goToNodeType]);
  const panels = (0, _react.useMemo)(() => [{
    id: 'firstPanel',
    items: [{
      'data-test-subj': 'goToHost',
      name: getDisplayNameForType('host'),
      onClick: goToHost
    }, {
      'data-test-subj': 'goToPods',
      name: getDisplayNameForType('pod'),
      onClick: goToK8
    }, {
      'data-test-subj': 'goToDocker',
      name: getDisplayNameForType('container'),
      onClick: goToDocker
    }, {
      name: 'AWS',
      panel: 'awsPanel'
    }]
  }, {
    id: 'awsPanel',
    title: 'AWS',
    items: [{
      name: getDisplayNameForType('awsEC2'),
      onClick: goToAwsEC2
    }, {
      name: getDisplayNameForType('awsS3'),
      onClick: goToAwsS3
    }, {
      name: getDisplayNameForType('awsRDS'),
      onClick: goToAwsRDS
    }, {
      name: getDisplayNameForType('awsSQS'),
      onClick: goToAwsSQS
    }]
  }], [goToAwsEC2, goToAwsRDS, goToAwsS3, goToAwsSQS, goToDocker, goToHost, goToK8]);
  const selectedText = (0, _react.useMemo)(() => {
    return getDisplayNameForType(nodeType);
  }, [nodeType]);
  const button = /*#__PURE__*/_react.default.createElement(_dropdown_button.DropdownButton, {
    "data-test-subj": 'openInventorySwitcher',
    onClick: openPopover,
    label: _i18n.i18n.translate('xpack.infra.waffle.showLabel', {
      defaultMessage: 'Show'
    }),
    showKubernetesInfo: true
  }, selectedText);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "contextMenu",
    button: button,
    isOpen: isOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: "firstPanel",
    panels: panels
  }));
};
exports.WaffleInventorySwitcher = WaffleInventorySwitcher;