"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SummaryTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _states = require("./states");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NOT_AVAILABLE_LABEL = _i18n.i18n.translate('xpack.infra.notAvailableLabel', {
  defaultMessage: 'N/A'
});
const processSummaryNotAvailable = {
  total: NOT_AVAILABLE_LABEL,
  running: NOT_AVAILABLE_LABEL,
  sleeping: NOT_AVAILABLE_LABEL,
  dead: NOT_AVAILABLE_LABEL,
  stopped: NOT_AVAILABLE_LABEL,
  idle: NOT_AVAILABLE_LABEL,
  zombie: NOT_AVAILABLE_LABEL,
  unknown: NOT_AVAILABLE_LABEL
};
const SummaryTable = ({
  processSummary,
  isLoading
}) => {
  const summary = !(processSummary !== null && processSummary !== void 0 && processSummary.total) ? processSummaryNotAvailable : processSummary;
  const processCount = (0, _react.useMemo)(() => ({
    total: isLoading ? -1 : summary.total,
    ...(0, _lodash.mapValues)(_states.STATE_NAMES, () => isLoading ? -1 : 0),
    ...(isLoading ? {} : summary)
  }), [summary, isLoading]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    wrap: true
  }, Object.entries(processCount).map(([field, value]) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: field
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "infraProcessesSummaryTableItem",
    compressed: true
  }, /*#__PURE__*/_react.default.createElement(ColumnTitle, null, columnTitles[field]), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, value === -1 ? /*#__PURE__*/_react.default.createElement(LoadingSpinner, null) : value))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }));
};
exports.SummaryTable = SummaryTable;
const columnTitles = {
  total: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.headingTotalProcesses', {
    defaultMessage: 'Total processes'
  }),
  ..._states.STATE_NAMES
};
const LoadingSpinner = (0, _common.euiStyled)(_eui.EuiLoadingSpinner).attrs({
  size: 'm'
})`
  margin-top: 2px;
  margin-bottom: 3px;
`;
const ColumnTitle = (0, _common.euiStyled)(_eui.EuiDescriptionListTitle)`
  white-space: nowrap;
`;