"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _common = require("@kbn/kibana-react-plugin/common");
var _shared = require("../shared");
var _use_snaphot = require("../../../../hooks/use_snaphot");
var _use_waffle_options = require("../../../../hooks/use_waffle_options");
var _metrics_source = require("../../../../../../../containers/metrics_source");
var _inventory_models = require("../../../../../../../../common/inventory_models");
var _kuery = require("../../../../../../../utils/kuery");
var _use_metrics_explorer_options = require("../../../../../metrics_explorer/hooks/use_metrics_explorer_options");
var _color_palette = require("../../../../../../../../common/color_palette");
var _create_inventory_metric_formatter = require("../../../../lib/create_inventory_metric_formatter");
var _calculate_domain = require("../../../../../metrics_explorer/components/helpers/calculate_domain");
var _chart_section = require("./chart_section");
var _translations = require("./translations");
var _time_dropdown = require("./time_dropdown");
var _get_custom_metric_label = require("../../../../../../../../common/formatters/get_custom_metric_label");
var _create_formatter_for_metric = require("../../../../../metrics_explorer/components/helpers/create_formatter_for_metric");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ONE_HOUR = 60 * 60 * 1000;
const TabComponent = props => {
  const cpuChartRef = (0, _react.useRef)(null);
  const networkChartRef = (0, _react.useRef)(null);
  const memoryChartRef = (0, _react.useRef)(null);
  const loadChartRef = (0, _react.useRef)(null);
  const logRateChartRef = (0, _react.useRef)(null);
  const customMetricRefs = (0, _react.useRef)({});
  const [time, setTime] = (0, _react.useState)(ONE_HOUR);
  const chartRefs = (0, _react.useMemo)(() => {
    const refs = [cpuChartRef, networkChartRef, memoryChartRef, loadChartRef, logRateChartRef];
    return [...refs, customMetricRefs];
  }, [cpuChartRef, networkChartRef, memoryChartRef, loadChartRef, logRateChartRef, customMetricRefs]);
  const {
    sourceId,
    createDerivedIndexPattern
  } = (0, _metrics_source.useSourceContext)();
  const {
    nodeType,
    accountId,
    region,
    customMetrics
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    currentTime,
    node
  } = props;
  const derivedIndexPattern = (0, _react.useMemo)(() => createDerivedIndexPattern(), [createDerivedIndexPattern]);
  let filter = `${(0, _inventory_models.findInventoryFields)(nodeType).id}: "${node.id}"`;
  if (filter) {
    filter = (0, _kuery.convertKueryToElasticSearchQuery)(filter, derivedIndexPattern);
  }
  const buildCustomMetric = (0, _react.useCallback)((field, id, aggregation = 'avg') => ({
    type: 'custom',
    aggregation,
    field,
    id
  }), []);
  const updateTime = (0, _react.useCallback)(e => {
    setTime(Number(e.currentTarget.value));
  }, [setTime]);
  const timeRange = {
    interval: '1m',
    to: currentTime,
    from: currentTime - time,
    ignoreLookback: true
  };
  const defaultMetrics = [{
    type: 'rx'
  }, {
    type: 'tx'
  }, buildCustomMetric('system.cpu.user.pct', 'user'), buildCustomMetric('system.cpu.system.pct', 'system'), buildCustomMetric('system.load.1', 'load1m'), buildCustomMetric('system.load.5', 'load5m'), buildCustomMetric('system.load.15', 'load15m'), buildCustomMetric('system.memory.actual.used.bytes', 'usedMemory'), buildCustomMetric('system.memory.actual.free', 'freeMemory'), buildCustomMetric('system.cpu.cores', 'cores', 'max')];
  const {
    nodes,
    reload
  } = (0, _use_snaphot.useSnapshot)({
    filterQuery: filter,
    metrics: [...defaultMetrics, ...customMetrics],
    groupBy: [],
    nodeType,
    sourceId,
    currentTime,
    accountId,
    region,
    sendRequestImmediately: false,
    timerange: timeRange
  });
  const {
    nodes: logRateNodes,
    reload: reloadLogRate
  } = (0, _use_snaphot.useSnapshot)({
    filterQuery: filter,
    metrics: [{
      type: 'logRate'
    }],
    groupBy: [],
    nodeType,
    sourceId,
    currentTime,
    accountId,
    region,
    sendRequestImmediately: false,
    timerange: timeRange
  });
  const getDomain = (0, _react.useCallback)((timeseries, ms) => {
    const dataDomain = timeseries ? (0, _calculate_domain.calculateDomain)(timeseries, ms, false) : null;
    return dataDomain ? {
      max: dataDomain.max * 1.1,
      // add 10% headroom.
      min: dataDomain.min
    } : {
      max: 0,
      min: 0
    };
  }, []);
  const dateFormatter = (0, _react.useCallback)(timeseries => {
    var _first, _last;
    if (!timeseries) return () => '';
    const firstTimestamp = (_first = (0, _lodash.first)(timeseries.rows)) === null || _first === void 0 ? void 0 : _first.timestamp;
    const lastTimestamp = (_last = (0, _lodash.last)(timeseries.rows)) === null || _last === void 0 ? void 0 : _last.timestamp;
    if (firstTimestamp == null || lastTimestamp == null) {
      return value => `${value}`;
    }
    return (0, _charts.niceTimeFormatter)([firstTimestamp, lastTimestamp]);
  }, []);
  const networkFormatter = (0, _react.useMemo)(() => (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)({
    type: 'rx'
  }), []);
  const cpuFormatter = (0, _react.useMemo)(() => (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)({
    type: 'cpu'
  }), []);
  const memoryFormatter = (0, _react.useMemo)(() => (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)({
    type: 's3BucketSize'
  }), []);
  const loadFormatter = (0, _react.useMemo)(() => (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)({
    type: 'load'
  }), []);
  const logRateFormatter = (0, _react.useMemo)(() => (0, _create_inventory_metric_formatter.createInventoryMetricFormatter)({
    type: 'logRate'
  }), []);
  const mergeTimeseries = (0, _react.useCallback)((...series) => {
    const base = series[0];
    const otherSeries = series.slice(1);
    base.rows = base.rows.map((b, rowIdx) => {
      const newRow = {
        ...b
      };
      otherSeries.forEach((o, idx) => {
        newRow[`metric_${idx + 1}`] = o.rows[rowIdx].metric_0;
      });
      return newRow;
    });
    return base;
  }, []);
  const buildChartMetricLabels = (0, _react.useCallback)((labels, aggregation) => {
    const baseMetric = {
      color: _color_palette.Color.color0,
      aggregation,
      label: 'System'
    };
    return labels.map((label, idx) => {
      return {
        ...baseMetric,
        color: _color_palette.Color[`color${idx}`],
        label
      };
    });
  }, []);
  const pointerUpdate = (0, _react.useCallback)(event => {
    chartRefs.forEach(ref => {
      if (ref.current) {
        if (ref.current instanceof _charts.Chart) {
          ref.current.dispatchExternalPointerEvent(event);
        } else {
          const charts = Object.values(ref.current);
          charts.forEach(c => {
            if (c) {
              c.dispatchExternalPointerEvent(event);
            }
          });
        }
      }
    });
  }, [chartRefs]);
  const getTimeseries = (0, _react.useCallback)(metricName => {
    if (!nodes || !nodes.length) {
      return null;
    }
    return nodes[0].metrics.find(m => m.name === metricName).timeseries;
  }, [nodes]);
  const getLogRateTimeseries = (0, _react.useCallback)(() => {
    if (!logRateNodes) {
      return null;
    }
    if (logRateNodes.length === 0) {
      return {
        rows: [],
        columns: [],
        id: '0'
      };
    }
    return logRateNodes[0].metrics.find(m => m.name === 'logRate').timeseries;
  }, [logRateNodes]);
  const systemMetricsTs = (0, _react.useMemo)(() => getTimeseries('system'), [getTimeseries]);
  const userMetricsTs = (0, _react.useMemo)(() => getTimeseries('user'), [getTimeseries]);
  const rxMetricsTs = (0, _react.useMemo)(() => getTimeseries('rx'), [getTimeseries]);
  const txMetricsTs = (0, _react.useMemo)(() => getTimeseries('tx'), [getTimeseries]);
  const load1mMetricsTs = (0, _react.useMemo)(() => getTimeseries('load1m'), [getTimeseries]);
  const load5mMetricsTs = (0, _react.useMemo)(() => getTimeseries('load5m'), [getTimeseries]);
  const load15mMetricsTs = (0, _react.useMemo)(() => getTimeseries('load15m'), [getTimeseries]);
  const usedMemoryMetricsTs = (0, _react.useMemo)(() => getTimeseries('usedMemory'), [getTimeseries]);
  const freeMemoryMetricsTs = (0, _react.useMemo)(() => getTimeseries('freeMemory'), [getTimeseries]);
  const coresMetricsTs = (0, _react.useMemo)(() => getTimeseries('cores'), [getTimeseries]);
  const logRateMetricsTs = (0, _react.useMemo)(() => getLogRateTimeseries(), [getLogRateTimeseries]);
  (0, _react.useEffect)(() => {
    reload();
    reloadLogRate();
  }, [time, reload, reloadLogRate]);
  if (!systemMetricsTs || !userMetricsTs || !rxMetricsTs || !txMetricsTs || !load1mMetricsTs || !load5mMetricsTs || !load15mMetricsTs || !usedMemoryMetricsTs || !freeMemoryMetricsTs || !logRateMetricsTs) {
    return /*#__PURE__*/_react.default.createElement(LoadingPlaceholder, null);
  }
  const cpuChartMetrics = buildChartMetricLabels([_translations.SYSTEM_METRIC_NAME, _translations.USER_METRIC_NAME], 'avg');
  const logRateChartMetrics = buildChartMetricLabels([_translations.LOG_RATE_METRIC_NAME], 'rate');
  const networkChartMetrics = buildChartMetricLabels([_translations.INBOUND_METRIC_NAME, _translations.OUTBOUND_METRIC_NAME], 'rate');
  const loadChartMetrics = buildChartMetricLabels(['1m', '5m', '15m'], 'avg');
  const memoryChartMetrics = buildChartMetricLabels([_translations.USED_MEMORY_METRIC_NAME, _translations.FREE_MEMORY_METRIC_NAME], 'rate');
  systemMetricsTs.rows = systemMetricsTs.rows.slice().map((r, idx) => {
    const metric = r.metric_0;
    const cores = coresMetricsTs.rows[idx].metric_0;
    if (metric && cores) {
      r.metric_0 = metric / cores;
    }
    return r;
  });
  userMetricsTs.rows = userMetricsTs.rows.slice().map((r, idx) => {
    const metric = r.metric_0;
    const cores = coresMetricsTs.rows[idx].metric_0;
    if (metric && cores) {
      r.metric_0 = metric / cores;
    }
    return r;
  });
  const cpuTimeseries = mergeTimeseries(systemMetricsTs, userMetricsTs);
  const logRateTimeseries = mergeTimeseries(logRateMetricsTs);
  const networkTimeseries = mergeTimeseries(rxMetricsTs, txMetricsTs);
  const loadTimeseries = mergeTimeseries(load1mMetricsTs, load5mMetricsTs, load15mMetricsTs);
  const memoryTimeseries = mergeTimeseries(usedMemoryMetricsTs, freeMemoryMetricsTs);
  const formatter = dateFormatter(rxMetricsTs);
  return /*#__PURE__*/_react.default.createElement(_shared.TabContent, null, /*#__PURE__*/_react.default.createElement(_time_dropdown.TimeDropdown, {
    value: time,
    onChange: updateTime
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'l'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: 'l',
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(ChartGridItem, null, /*#__PURE__*/_react.default.createElement(_chart_section.ChartSection, {
    title: _translations.CPU_CHART_TITLE,
    style: _use_metrics_explorer_options.MetricsExplorerChartType.line,
    chartRef: cpuChartRef,
    series: [{
      metric: cpuChartMetrics[0],
      series: systemMetricsTs
    }, {
      metric: cpuChartMetrics[1],
      series: userMetricsTs
    }],
    tickFormatterForTime: formatter,
    tickFormatter: cpuFormatter,
    onPointerUpdate: pointerUpdate,
    domain: getDomain(cpuTimeseries, cpuChartMetrics)
  })), /*#__PURE__*/_react.default.createElement(ChartGridItem, null, /*#__PURE__*/_react.default.createElement(_chart_section.ChartSection, {
    title: _translations.LOAD_CHART_TITLE,
    style: _use_metrics_explorer_options.MetricsExplorerChartType.line,
    chartRef: loadChartRef,
    series: [{
      metric: loadChartMetrics[0],
      series: load1mMetricsTs
    }, {
      metric: loadChartMetrics[1],
      series: load5mMetricsTs
    }, {
      metric: loadChartMetrics[2],
      series: load15mMetricsTs
    }],
    tickFormatterForTime: formatter,
    tickFormatter: loadFormatter,
    onPointerUpdate: pointerUpdate,
    domain: getDomain(loadTimeseries, loadChartMetrics)
  })), /*#__PURE__*/_react.default.createElement(ChartGridItem, null, /*#__PURE__*/_react.default.createElement(_chart_section.ChartSection, {
    title: _translations.MEMORY_CHART_TITLE,
    style: _use_metrics_explorer_options.MetricsExplorerChartType.line,
    chartRef: memoryChartRef,
    series: [{
      metric: memoryChartMetrics[0],
      series: usedMemoryMetricsTs
    }, {
      metric: memoryChartMetrics[1],
      series: freeMemoryMetricsTs
    }],
    tickFormatterForTime: formatter,
    tickFormatter: memoryFormatter,
    onPointerUpdate: pointerUpdate,
    domain: getDomain(memoryTimeseries, memoryChartMetrics)
  })), /*#__PURE__*/_react.default.createElement(ChartGridItem, null, /*#__PURE__*/_react.default.createElement(_chart_section.ChartSection, {
    title: _translations.NETWORK_CHART_TITLE,
    style: _use_metrics_explorer_options.MetricsExplorerChartType.line,
    chartRef: networkChartRef,
    series: [{
      metric: networkChartMetrics[0],
      series: rxMetricsTs
    }, {
      metric: networkChartMetrics[1],
      series: txMetricsTs
    }],
    tickFormatterForTime: formatter,
    tickFormatter: networkFormatter,
    onPointerUpdate: pointerUpdate,
    domain: getDomain(networkTimeseries, networkChartMetrics),
    stack: true
  })), /*#__PURE__*/_react.default.createElement(ChartGridItem, null, /*#__PURE__*/_react.default.createElement(_chart_section.ChartSection, {
    title: _translations.LOG_RATE_CHART_TITLE,
    style: _use_metrics_explorer_options.MetricsExplorerChartType.line,
    chartRef: logRateChartRef,
    series: [{
      metric: logRateChartMetrics[0],
      series: logRateMetricsTs
    }],
    tickFormatterForTime: formatter,
    tickFormatter: logRateFormatter,
    onPointerUpdate: pointerUpdate,
    domain: getDomain(logRateTimeseries, logRateChartMetrics),
    stack: true
  })), customMetrics.map(c => {
    const metricTS = getTimeseries(c.id);
    const chartMetrics = buildChartMetricLabels([c.field], c.aggregation);
    if (!metricTS) return null;
    return /*#__PURE__*/_react.default.createElement(ChartGridItem, null, /*#__PURE__*/_react.default.createElement(_chart_section.ChartSection, {
      title: (0, _get_custom_metric_label.getCustomMetricLabel)(c),
      style: _use_metrics_explorer_options.MetricsExplorerChartType.line,
      chartRef: r => {
        customMetricRefs.current[c.id] = r;
      },
      series: [{
        metric: chartMetrics[0],
        series: metricTS
      }],
      tickFormatterForTime: formatter,
      tickFormatter: (0, _create_formatter_for_metric.createFormatterForMetric)(c),
      onPointerUpdate: pointerUpdate,
      domain: getDomain(mergeTimeseries(metricTS), chartMetrics),
      stack: true
    }));
  })));
};
const ChartGridItem = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  overflow: hidden
`;
const LoadingPlaceholder = () => {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '100%',
      height: '200px',
      padding: '16px',
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "xl"
  }));
};
const MetricsTab = {
  id: 'metrics',
  name: _i18n.i18n.translate('xpack.infra.nodeDetails.tabs.metrics', {
    defaultMessage: 'Metrics'
  }),
  content: TabComponent
};
exports.MetricsTab = MetricsTab;