"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retrieveFieldsFromFilter = exports.buildCombinedHostsFilter = void 0;
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildCombinedHostsFilter = ({
  field,
  values,
  dataView
}) => {
  if (!dataView) {
    return {
      query: {
        terms: {
          'host.name': values
        }
      },
      meta: {}
    };
  }
  const indexField = dataView.getFieldByName(field);
  const filtersFromValues = values.map(value => (0, _esQuery.buildPhraseFilter)(indexField, value, dataView));
  return (0, _esQuery.buildCombinedFilter)(_esQuery.BooleanRelation.OR, filtersFromValues, dataView);
};
exports.buildCombinedHostsFilter = buildCombinedHostsFilter;
const retrieveFieldsFromFilter = (filters, fields = []) => {
  for (const filter of filters) {
    if ((0, _esQuery.isCombinedFilter)(filter)) {
      retrieveFieldsFromFilter(filter.meta.params, fields);
    }
    if (filter.meta.key) {
      fields.push(filter.meta.key);
    }
  }
  return fields;
};
exports.retrieveFieldsFromFilter = retrieveFieldsFromFilter;