"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_lens_attributes = require("../../../../../../hooks/use_lens_attributes");
var _use_data_view = require("../../../hooks/use_data_view");
var _use_unified_search = require("../../../hooks/use_unified_search");
var _use_hosts_view = require("../../../hooks/use_hosts_view");
var _utils = require("../../../utils");
var _use_hosts_table = require("../../../hooks/use_hosts_table");
var _lens_wrapper = require("../../chart/lens_wrapper");
var _use_after_loaded_state = require("../../../hooks/use_after_loaded_state");
var _constants = require("../../../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensStyle = {
  height: _constants.METRIC_CHART_MIN_HEIGHT
};
const MetricChart = ({
  title,
  type,
  breakdownSize
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    searchCriteria,
    onSubmit
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    dataView
  } = (0, _use_data_view.useMetricsDataViewContext)();
  const {
    requestTs,
    loading
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    currentPage
  } = (0, _use_hosts_table.useHostsTableContext)();
  const shouldUseSearchCriteria = currentPage.length === 0;

  // prevents requestTs and serchCriteria states from reloading the chart
  // we want it to reload only once the table has finished loading
  const {
    afterLoadedState
  } = (0, _use_after_loaded_state.useAfterLoadedState)(loading, {
    lastReloadRequestTime: requestTs,
    ...searchCriteria
  });
  const {
    attributes,
    getExtraActions,
    error
  } = (0, _use_lens_attributes.useLensAttributes)({
    type,
    dataView,
    options: {
      title,
      breakdownSize
    },
    visualizationType: 'lineChart'
  });
  const filters = (0, _react.useMemo)(() => {
    return shouldUseSearchCriteria ? afterLoadedState.filters : [(0, _utils.buildCombinedHostsFilter)({
      field: 'host.name',
      values: currentPage.map(p => p.name),
      dataView
    })];
  }, [afterLoadedState.filters, currentPage, dataView, shouldUseSearchCriteria]);
  const extraActions = (0, _react.useMemo)(() => getExtraActions({
    timeRange: afterLoadedState.dateRange,
    query: shouldUseSearchCriteria ? afterLoadedState.query : undefined,
    filters
  }), [afterLoadedState.dateRange, afterLoadedState.query, filters, getExtraActions, shouldUseSearchCriteria]);
  const handleBrushEnd = (0, _react.useCallback)(({
    range
  }) => {
    const [min, max] = range;
    onSubmit({
      dateRange: {
        from: new Date(min).toISOString(),
        to: new Date(max).toISOString(),
        mode: 'absolute'
      }
    });
  }, [onSubmit]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "m",
    hasShadow: false,
    hasBorder: true,
    paddingSize: error ? 'm' : 'none',
    css: (0, _react2.css)`
        min-height: calc(${_constants.METRIC_CHART_MIN_HEIGHT}px + ${euiTheme.size.l});
        position: relative;
      `,
    "data-test-subj": `hostsView-metricChart-${type}`
  }, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      minHeight: '100%',
      alignContent: 'center'
    },
    gutterSize: "xs",
    justifyContent: "center",
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18n, {
    token: "'xpack.infra.hostsViewPage.errorOnLoadingLensDependencies'",
    default: "There was an error trying to load Lens Plugin."
  })))) : /*#__PURE__*/_react.default.createElement(_lens_wrapper.LensWrapper, {
    id: `hostsViewsmetricsChart-${type}`,
    attributes: attributes,
    style: lensStyle,
    extraActions: extraActions,
    lastReloadRequestTime: afterLoadedState.lastReloadRequestTime,
    dateRange: afterLoadedState.dateRange,
    filters: filters,
    query: shouldUseSearchCriteria ? afterLoadedState.query : undefined,
    onBrushEnd: handleBrushEnd,
    loading: loading,
    hasTitle: true
  }));
};
exports.MetricChart = MetricChart;