"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColumnHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _public = require("@kbn/core/public");
var _use_boolean = require("../../../../../hooks/use_boolean");
var _tooltip_content = require("../metric_explanation/tooltip_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SEARCH_BAR_OFFSET = 250;
const ANCHOR_SPACING = 10;
const findTableParentElement = element => {
  let currentElement = element;
  while (currentElement && currentElement.className !== _public.APP_WRAPPER_CLASS) {
    currentElement = currentElement.parentElement;
  }
  return currentElement;
};
const ColumnHeader = /*#__PURE__*/_react.default.memo(({
  label,
  toolTip,
  formula,
  popoverContainerRef
}) => {
  const buttonRef = (0, _react.useRef)(null);
  const containerRef = (0, _react.useRef)(null);
  const [offset, setOffset] = (0, _react.useState)(0);
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _use_boolean.useBoolean)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _react.useLayoutEffect)(() => {
    containerRef.current = findTableParentElement(buttonRef.current);
  }, []);
  const calculateHeaderOffset = () => {
    var _containerRef$current, _containerRef$current2;
    const {
      top: containerTop = 0
    } = (_containerRef$current = (_containerRef$current2 = containerRef.current) === null || _containerRef$current2 === void 0 ? void 0 : _containerRef$current2.getBoundingClientRect()) !== null && _containerRef$current !== void 0 ? _containerRef$current : {};
    const headerOffset = containerTop + window.scrollY;
    return headerOffset;
  };
  const onButtonClick = (0, _react.useCallback)(e => {
    var _buttonRef$current$ge, _buttonRef$current;
    e.preventDefault();
    e.stopPropagation();
    const {
      top: buttonTop = 0
    } = (_buttonRef$current$ge = (_buttonRef$current = buttonRef.current) === null || _buttonRef$current === void 0 ? void 0 : _buttonRef$current.getBoundingClientRect()) !== null && _buttonRef$current$ge !== void 0 ? _buttonRef$current$ge : {};

    // gets the actual page position, discounting anything above the page content (e.g: header, dismissible banner)
    const headerOffset = calculateHeaderOffset();
    // determines if the scroll position is close to overlapping with the button
    const scrollPosition = buttonTop - headerOffset - SEARCH_BAR_OFFSET;
    const isAboveElement = scrollPosition <= 0;

    // offset to be taken into account when positioning the popover
    setOffset(headerOffset * (isAboveElement ? -1 : 1) + ANCHOR_SPACING);
    togglePopover();
  }, [togglePopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
            overflow-wrap: break-word !important;
            word-break: break-word;
            min-width: 0;
            text-overflow: ellipsis;
            overflow: hidden;
          `
  }, label), toolTip && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "s",
    buttonRef: el => buttonRef.current = el,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": "hostsViewTableColumnPopoverButton",
      type: "questionInCircle",
      onClick: onButtonClick
    }),
    insert: popoverContainerRef && popoverContainerRef !== null && popoverContainerRef !== void 0 && popoverContainerRef.current ? {
      sibling: popoverContainerRef.current,
      position: 'after'
    } : undefined,
    offset: offset,
    anchorPosition: offset <= 0 ? 'downCenter' : 'upCenter',
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    zIndex: Number(euiTheme.levels.header) - 1,
    panelStyle: {
      maxWidth: 350
    }
  }, /*#__PURE__*/_react.default.createElement(_tooltip_content.TooltipContent, {
    formula: formula,
    description: toolTip,
    showDocumentationLink: true
  })));
});
exports.ColumnHeader = ColumnHeader;