"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_kibana_header = require("../../../../../hooks/use_kibana_header");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _use_unified_search = require("../../hooks/use_unified_search");
var _controls_content = require("./controls_content");
var _use_data_view = require("../../hooks/use_data_view");
var _limit_options = require("./limit_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnifiedSearchBar = () => {
  var _application$capabili, _application$capabili2;
  const {
    services: {
      unifiedSearch,
      application
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    dataView
  } = (0, _use_data_view.useMetricsDataViewContext)();
  const {
    searchCriteria,
    onSubmit
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    SearchBar
  } = unifiedSearch.ui;
  const onLimitChange = limit => {
    onSubmit({
      limit
    });
  };
  const onPanelFiltersChange = (0, _react.useCallback)(panelFilters => {
    onSubmit({
      panelFilters
    });
  }, [onSubmit]);
  const handleRefresh = (payload, isUpdate) => {
    // This makes sure `onQueryChange` is only called when the submit button is clicked
    if (isUpdate === false) {
      onSubmit(payload);
    }
  };
  return /*#__PURE__*/_react.default.createElement(StickyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: 'Infra Hosts',
    displayStyle: "inPage",
    indexPatterns: dataView && [dataView],
    placeholder: _i18n.i18n.translate('xpack.infra.hosts.searchPlaceholder', {
      defaultMessage: 'Search hosts (E.g. cloud.provider:gcp AND system.load.1 > 0.5)'
    }),
    onQuerySubmit: handleRefresh,
    showSaveQuery: Boolean(application === null || application === void 0 ? void 0 : (_application$capabili = application.capabilities) === null || _application$capabili === void 0 ? void 0 : (_application$capabili2 = _application$capabili.visualize) === null || _application$capabili2 === void 0 ? void 0 : _application$capabili2.saveQuery),
    showDatePicker: true,
    showFilterBar: true,
    showQueryInput: true,
    showQueryMenu: true,
    useDefaultBehaviors: true,
    isAutoRefreshDisabled: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    wrap: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_controls_content.ControlsContent, {
    timeRange: searchCriteria.dateRange,
    dataView: dataView,
    query: searchCriteria.query,
    filters: searchCriteria.filters,
    onFiltersChange: onPanelFiltersChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_limit_options.LimitOptions, {
    limit: searchCriteria.limit,
    onChange: onLimitChange
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    css: (0, _react2.css)`
          margin-bottom: 0;
        `
  }));
};
exports.UnifiedSearchBar = UnifiedSearchBar;
const StickyContainer = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    headerHeight
  } = (0, _use_kibana_header.useKibanaHeader)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        position: sticky;
        top: ${headerHeight}px;
        z-index: ${euiTheme.levels.navigation};
        background: ${euiTheme.colors.emptyShade};
        padding: ${euiTheme.size.m} ${euiTheme.size.l} 0px;
        margin: -${euiTheme.size.l} -${euiTheme.size.l} 0px;
        min-height: calc(${euiTheme.size.xxxl} * 2);
      `
  }, children);
};