"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tile = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_lens_attributes = require("../../../../../hooks/use_lens_attributes");
var _use_data_view = require("../../hooks/use_data_view");
var _use_unified_search = require("../../hooks/use_unified_search");
var _use_hosts_view = require("../../hooks/use_hosts_view");
var _lens_wrapper = require("../chart/lens_wrapper");
var _utils = require("../../utils");
var _use_host_count = require("../../hooks/use_host_count");
var _use_after_loaded_state = require("../../hooks/use_after_loaded_state");
var _tooltip_content = require("../metric_explanation/tooltip_content");
var _constants = require("../../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Tile = ({
  title,
  type,
  backgroundColor,
  toolTip,
  style,
  decimals = 1,
  trendLine = false
}) => {
  const {
    searchCriteria,
    onSubmit
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    dataView
  } = (0, _use_data_view.useMetricsDataViewContext)();
  const {
    requestTs,
    hostNodes,
    loading: hostsLoading
  } = (0, _use_hosts_view.useHostsViewContext)();
  const {
    data: hostCountData,
    isRequestRunning: hostCountLoading
  } = (0, _use_host_count.useHostCountContext)();
  const shouldUseSearchCriteria = hostNodes.length === 0;
  const getSubtitle = () => {
    var _hostCountData$count$;
    return searchCriteria.limit < ((_hostCountData$count$ = hostCountData === null || hostCountData === void 0 ? void 0 : hostCountData.count.value) !== null && _hostCountData$count$ !== void 0 ? _hostCountData$count$ : 0) ? _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.subtitle.average.limit', {
      defaultMessage: 'Average (of {limit} hosts)',
      values: {
        limit: searchCriteria.limit
      }
    }) : _i18n.i18n.translate('xpack.infra.hostsViewPage.metricTrend.subtitle.average', {
      defaultMessage: 'Average'
    });
  };
  const {
    formula,
    attributes,
    getExtraActions,
    error
  } = (0, _use_lens_attributes.useLensAttributes)({
    type,
    dataView,
    options: {
      backgroundColor,
      decimals,
      subtitle: getSubtitle(),
      showTrendLine: trendLine,
      showTitle: false,
      title
    },
    visualizationType: 'metricChart'
  });
  const filters = (0, _react.useMemo)(() => {
    return shouldUseSearchCriteria ? searchCriteria.filters : [(0, _utils.buildCombinedHostsFilter)({
      field: 'host.name',
      values: hostNodes.map(p => p.name),
      dataView
    })];
  }, [shouldUseSearchCriteria, searchCriteria.filters, hostNodes, dataView]);
  const loading = hostsLoading || !attributes || hostCountLoading;

  // prevents requestTs and serchCriteria states from reloading the chart
  // we want it to reload only once the host count and table have finished loading
  const {
    afterLoadedState
  } = (0, _use_after_loaded_state.useAfterLoadedState)(loading, {
    attributes,
    lastReloadRequestTime: requestTs,
    ...searchCriteria,
    filters
  });
  const extraActions = (0, _react.useMemo)(() => getExtraActions({
    timeRange: afterLoadedState.dateRange,
    query: shouldUseSearchCriteria ? afterLoadedState.query : undefined,
    filters
  }), [afterLoadedState.dateRange, afterLoadedState.query, filters, getExtraActions, shouldUseSearchCriteria]);
  const handleBrushEnd = (0, _react.useCallback)(({
    range
  }) => {
    const [min, max] = range;
    onSubmit({
      dateRange: {
        from: new Date(min).toISOString(),
        to: new Date(max).toISOString(),
        mode: 'absolute'
      }
    });
  }, [onSubmit]);
  return /*#__PURE__*/_react.default.createElement(EuiPanelStyled, {
    hasShadow: false,
    paddingSize: error ? 'm' : 'none',
    "data-test-subj": `hostsViewKPI-${type}`
  }, error ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      minHeight: '100%',
      alignContent: 'center'
    },
    gutterSize: "xs",
    justifyContent: "center",
    alignItems: "center",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18n, {
    token: "'xpack.infra.hostsViewPage.errorOnLoadingLensDependencies'",
    default: "There was an error trying to load Lens Plugin."
  })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "regular",
    content: /*#__PURE__*/_react.default.createElement(_tooltip_content.TooltipContent, {
      formula: formula,
      description: toolTip
    }),
    anchorClassName: "eui-fullWidth"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_lens_wrapper.LensWrapper, {
    id: `hostsViewKPIGrid${type}Tile`,
    attributes: afterLoadedState.attributes,
    style: style,
    extraActions: extraActions,
    lastReloadRequestTime: afterLoadedState.lastReloadRequestTime,
    dateRange: afterLoadedState.dateRange,
    filters: afterLoadedState.filters,
    query: shouldUseSearchCriteria ? afterLoadedState.query : undefined,
    onBrushEnd: handleBrushEnd,
    loading: loading
  }))));
};
exports.Tile = Tile;
const EuiPanelStyled = (0, _styledComponents.default)(_eui.EuiPanel)`
  min-height: ${_constants.KPI_CHART_MIN_HEIGHT};
  .echMetric {
    border-radius: ${({
  theme
}) => theme.eui.euiBorderRadius};
    pointer-events: none;
  }
`;