"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_unified_search = require("../../hooks/use_unified_search");
var _use_host_flyout_url_state = require("../../hooks/use_host_flyout_url_state");
var _asset_details = require("../../../../../components/asset_details/asset_details");
var _tabs = require("./tabs");
var _use_log_view_reference = require("../../hooks/use_log_view_reference");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NODE_TYPE = 'host';
const FlyoutWrapper = ({
  node,
  closeFlyout
}) => {
  const {
    getDateRangeAsTimestamp
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    logViewReference,
    loading
  } = (0, _use_log_view_reference.useLogViewReference)({
    id: 'hosts-flyout-logs-view'
  });
  const currentTimeRange = (0, _react.useMemo)(() => ({
    ...getDateRangeAsTimestamp(),
    interval: '1m'
  }), [getDateRangeAsTimestamp]);
  const [hostFlyoutState, setHostFlyoutState] = (0, _use_host_flyout_url_state.useHostFlyoutUrlState)();
  return /*#__PURE__*/_react.default.createElement(_asset_details.AssetDetails, {
    node: node,
    nodeType: NODE_TYPE,
    currentTimeRange: currentTimeRange,
    activeTabId: hostFlyoutState === null || hostFlyoutState === void 0 ? void 0 : hostFlyoutState.tabId,
    overrides: {
      metadata: {
        query: hostFlyoutState === null || hostFlyoutState === void 0 ? void 0 : hostFlyoutState.metadataSearch,
        showActionsColumn: true
      },
      processes: {
        query: hostFlyoutState === null || hostFlyoutState === void 0 ? void 0 : hostFlyoutState.processSearch
      },
      logs: {
        query: hostFlyoutState === null || hostFlyoutState === void 0 ? void 0 : hostFlyoutState.logsSearch,
        logView: {
          reference: logViewReference,
          loading
        }
      }
    },
    onTabsStateChange: state => {
      var _state$metadata, _state$processes, _state$logs;
      return setHostFlyoutState({
        metadataSearch: (_state$metadata = state.metadata) === null || _state$metadata === void 0 ? void 0 : _state$metadata.query,
        processSearch: (_state$processes = state.processes) === null || _state$processes === void 0 ? void 0 : _state$processes.query,
        logsSearch: (_state$logs = state.logs) === null || _state$logs === void 0 ? void 0 : _state$logs.query,
        tabId: state.activeTabId
      });
    },
    tabs: _tabs.orderedFlyoutTabs,
    links: ['apmServices', 'uptime'],
    renderMode: {
      showInFlyout: true,
      closeFlyout
    }
  });
};
exports.FlyoutWrapper = FlyoutWrapper;