"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartLoader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartLoader = ({
  children,
  loading,
  style,
  loadedOnce = false,
  hasTitle = false
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(LoaderContainer, null, loading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    css: (0, _react2.css)`
            top: ${loadedOnce && hasTitle ? euiTheme.size.l : 0};
            z-index: ${Number(euiTheme.levels.header) - 1};
          `
  }), loading && !loadedOnce ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      ...style,
      marginTop: hasTitle ? euiTheme.size.l : 0
    },
    justifyContent: "center",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    mono: true,
    size: "l"
  }))) : children);
};
exports.ChartLoader = ChartLoader;
const LoaderContainer = _common.euiStyled.div`
  position: relative;
  border-radius: ${({
  theme
}) => theme.eui.euiSizeS};
  overflow: hidden;
  height: 100%;
`;