"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamPageContentForState = exports.ConnectedStreamPageContent = void 0;
var _react = require("@xstate/react");
var _react2 = _interopRequireWildcard(require("react"));
var _source_loading_page = require("../../../components/source_loading_page");
var _state = require("../../../observability_logs/log_stream_page/state");
var _xstate_helpers = require("../../../observability_logs/xstate_helpers");
var _page_log_view_error = require("../shared/page_log_view_error");
var _stream_page_template = require("./components/stream_page_template");
var _page_logs_content = require("./page_logs_content");
var _page_missing_indices_content = require("./page_missing_indices_content");
var _page_providers = require("./page_providers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectedStreamPageContent = () => {
  const logStreamPageStateService = (0, _state.useLogStreamPageStateContext)();
  const [logStreamPageState, logStreamPageSend] = (0, _react.useActor)(logStreamPageStateService);
  const pageStateCallbacks = (0, _react2.useMemo)(() => {
    return {
      updateTimeRange: timeRange => {
        logStreamPageSend({
          type: 'UPDATE_TIME_RANGE',
          timeRange
        });
      },
      jumpToTargetPosition: targetPosition => {
        logStreamPageSend({
          type: 'JUMP_TO_TARGET_POSITION',
          targetPosition
        });
      },
      jumpToTargetPositionTime: time => {
        logStreamPageSend({
          type: 'JUMP_TO_TARGET_POSITION',
          targetPosition: {
            time
          }
        });
      },
      reportVisiblePositions: visiblePositions => {
        logStreamPageSend({
          type: 'REPORT_VISIBLE_POSITIONS',
          visiblePositions
        });
      },
      startLiveStreaming: () => {
        logStreamPageSend({
          type: 'UPDATE_REFRESH_INTERVAL',
          refreshInterval: {
            pause: false
          }
        });
      },
      stopLiveStreaming: () => {
        logStreamPageSend({
          type: 'UPDATE_REFRESH_INTERVAL',
          refreshInterval: {
            pause: true
          }
        });
      }
    };
  }, [logStreamPageSend]);
  return /*#__PURE__*/_react2.default.createElement(StreamPageContentForState, {
    logStreamPageState: logStreamPageState,
    logStreamPageCallbacks: pageStateCallbacks
  });
};
exports.ConnectedStreamPageContent = ConnectedStreamPageContent;
const StreamPageContentForState = ({
  logStreamPageState,
  logStreamPageCallbacks
}) => {
  if (logStreamPageState.matches('uninitialized') || logStreamPageState.matches({
    hasLogViewIndices: 'uninitialized'
  }) || logStreamPageState.matches('loadingLogView')) {
    return /*#__PURE__*/_react2.default.createElement(_source_loading_page.SourceLoadingPage, null);
  } else if (logStreamPageState.matches('loadingLogViewFailed')) {
    return /*#__PURE__*/_react2.default.createElement(_page_log_view_error.ConnectedLogViewErrorPage, null);
  } else if (logStreamPageState.matches('missingLogViewIndices')) {
    return /*#__PURE__*/_react2.default.createElement(_page_missing_indices_content.StreamPageMissingIndicesContent, null);
  } else if (logStreamPageState.matches({
    hasLogViewIndices: 'initialized'
  })) {
    return /*#__PURE__*/_react2.default.createElement(_stream_page_template.LogStreamPageTemplate, {
      hasData: true,
      isDataLoading: false
    }, /*#__PURE__*/_react2.default.createElement(_page_providers.LogStreamPageContentProviders, {
      logStreamPageState: logStreamPageState,
      logStreamPageCallbacks: logStreamPageCallbacks
    }, /*#__PURE__*/_react2.default.createElement(_page_logs_content.StreamPageLogsContentForState, {
      logStreamPageState: logStreamPageState,
      logStreamPageCallbacks: logStreamPageCallbacks
    })));
  } else {
    return /*#__PURE__*/_react2.default.createElement(_xstate_helpers.InvalidStateCallout, {
      state: logStreamPageState
    });
  }
};
exports.StreamPageContentForState = StreamPageContentForState;