"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogIndicesFormElement = void 0;
var _react = require("react");
var _common = require("@kbn/kibana-utils-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _log_views = require("../../../../common/log_views");
var _use_kibana_index_patterns = require("../../../hooks/use_kibana_index_patterns");
var _form_elements = require("./form_elements");
var _validation_errors = require("./validation_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogIndicesFormElement = initialValue => {
  const indexPatternService = (0, _use_kibana_index_patterns.useKibanaIndexPatternService)();
  const trackIndexPatternValidationError = (0, _public.useUiTracker)({
    app: 'infra_logs'
  });
  const logIndicesFormElement = (0, _form_elements.useFormElement)({
    initialValue,
    validate: (0, _react.useMemo)(() => async logIndices => {
      if (logIndices == null) {
        return (0, _validation_errors.validateStringNotEmpty)('log data view', '');
      } else if (_log_views.logIndexNameReferenceRT.is(logIndices)) {
        return [...(0, _validation_errors.validateStringNotEmpty)('log indices', logIndices.indexName), ...(0, _validation_errors.validateStringNoSpaces)('log indices', logIndices.indexName)];
      } else {
        const emptyStringErrors = (0, _validation_errors.validateStringNotEmpty)('log data view', logIndices.dataViewId);
        if (emptyStringErrors.length > 0) {
          return emptyStringErrors;
        }
        const indexPatternErrors = await indexPatternService.get(logIndices.dataViewId).then(_validation_errors.validateIndexPattern, error => {
          if (error instanceof _common.SavedObjectNotFound) {
            return [{
              type: 'missing_index_pattern',
              indexPatternId: logIndices.dataViewId
            }];
          } else {
            throw error;
          }
        });
        if (indexPatternErrors.length > 0) {
          trackIndexPatternValidationError({
            metric: 'configuration_index_pattern_validation_failed'
          });
        } else {
          trackIndexPatternValidationError({
            metric: 'configuration_index_pattern_validation_succeeded'
          });
        }
        return indexPatternErrors;
      }
    }, [indexPatternService, trackIndexPatternValidationError])
  });
  return logIndicesFormElement;
};
exports.useLogIndicesFormElement = useLogIndicesFormElement;