"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.callGetLogEntryCategoryExamplesAPI = void 0;
var _http_api = require("../../../../../common/http_api");
var _runtime_types = require("../../../../../common/runtime_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const callGetLogEntryCategoryExamplesAPI = async (requestArgs, fetch) => {
  const {
    logViewReference,
    startTime,
    endTime,
    categoryId,
    exampleCount
  } = requestArgs;
  const response = await fetch(_http_api.LOG_ANALYSIS_GET_LOG_ENTRY_CATEGORY_EXAMPLES_PATH, {
    method: 'POST',
    body: JSON.stringify(_http_api.getLogEntryCategoryExamplesRequestPayloadRT.encode({
      data: {
        categoryId,
        exampleCount,
        logView: logViewReference,
        timeRange: {
          startTime,
          endTime
        }
      }
    })),
    version: '1'
  });
  return (0, _runtime_types.decodeOrThrow)(_http_api.getLogEntryCategoryExamplesSuccessReponsePayloadRT)(response);
};
exports.callGetLogEntryCategoryExamplesAPI = callGetLogEntryCategoryExamplesAPI;