"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryCategoriesPageContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _log_analysis = require("../../../../common/log_analysis");
var _loading_page = require("../../../components/loading_page");
var _log_analysis_setup = require("../../../components/logging/log_analysis_setup");
var _setup_flyout = require("../../../components/logging/log_analysis_setup/setup_flyout");
var _subscription_splash_content = require("../../../components/subscription_splash_content");
var _log_analysis2 = require("../../../containers/logs/log_analysis");
var _log_entry_categories = require("../../../containers/logs/log_analysis/modules/log_entry_categories");
var _use_log_view = require("../../../hooks/use_log_view");
var _page_template = require("../shared/page_template");
var _page_results_content = require("./page_results_content");
var _page_setup_content = require("./page_setup_content");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const logCategoriesTitle = _i18n.i18n.translate('xpack.infra.logs.logCategoriesTitle', {
  defaultMessage: 'Categories'
});
const LogEntryCategoriesPageContent = () => {
  const {
    hasLogAnalysisCapabilites,
    hasLogAnalysisReadCapabilities,
    hasLogAnalysisSetupCapabilities
  } = (0, _log_analysis2.useLogAnalysisCapabilitiesContext)();
  const {
    fetchJobStatus,
    setupStatus,
    jobStatus
  } = (0, _log_entry_categories.useLogEntryCategoriesModuleContext)();
  const {
    showModuleSetup
  } = (0, _setup_flyout.useLogAnalysisSetupFlyoutStateContext)();
  const showCategoriesModuleSetup = (0, _react.useCallback)(() => showModuleSetup('logs_ui_categories'), [showModuleSetup]);
  (0, _react.useEffect)(() => {
    if (hasLogAnalysisReadCapabilities) {
      fetchJobStatus();
    }
  }, [fetchJobStatus, hasLogAnalysisReadCapabilities]);
  if (!hasLogAnalysisCapabilites) {
    return /*#__PURE__*/_react.default.createElement(_subscription_splash_content.SubscriptionSplashPage, {
      "data-test-subj": "logsLogEntryCategoriesPage",
      pageHeader: {
        pageTitle: logCategoriesTitle
      }
    });
  } else if (!hasLogAnalysisReadCapabilities) {
    return /*#__PURE__*/_react.default.createElement(CategoriesPageTemplate, {
      isEmptyState: true
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingResultsPrivilegesPrompt, null));
  } else if (setupStatus.type === 'initializing') {
    return /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPage, {
      message: _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.jobStatusLoadingMessage', {
        defaultMessage: 'Checking status of categorization jobs...'
      })
    });
  } else if (setupStatus.type === 'unknown') {
    return /*#__PURE__*/_react.default.createElement(CategoriesPageTemplate, {
      isEmptyState: true
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.LogAnalysisSetupStatusUnknownPrompt, {
      retry: fetchJobStatus
    }));
  } else if ((0, _log_analysis.isJobStatusWithResults)(jobStatus['log-entry-categories-count'])) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_results_content.LogEntryCategoriesResultsContent, {
      onOpenSetup: showCategoriesModuleSetup,
      pageTitle: logCategoriesTitle
    }), /*#__PURE__*/_react.default.createElement(_setup_flyout.LogAnalysisSetupFlyout, {
      allowedModules: allowedSetupModules
    }));
  } else if (!hasLogAnalysisSetupCapabilities) {
    return /*#__PURE__*/_react.default.createElement(CategoriesPageTemplate, {
      isEmptyState: true
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingSetupPrivilegesPrompt, null));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CategoriesPageTemplate, {
      isEmptyState: true
    }, /*#__PURE__*/_react.default.createElement(_page_setup_content.LogEntryCategoriesSetupContent, {
      onOpenSetup: showCategoriesModuleSetup
    })), /*#__PURE__*/_react.default.createElement(_setup_flyout.LogAnalysisSetupFlyout, {
      allowedModules: allowedSetupModules
    }));
  }
};
exports.LogEntryCategoriesPageContent = LogEntryCategoriesPageContent;
const allowedSetupModules = ['logs_ui_categories'];
const CategoriesPageTemplate = ({
  children,
  ...rest
}) => {
  const {
    logViewStatus
  } = (0, _use_log_view.useLogViewContext)();
  return /*#__PURE__*/_react.default.createElement(_page_template.LogsPageTemplate, (0, _extends2.default)({
    hasData: (logViewStatus === null || logViewStatus === void 0 ? void 0 : logViewStatus.index) !== 'missing',
    "data-test-subj": "logsLogEntryCategoriesPage",
    pageHeader: rest.isEmptyState ? undefined : {
      pageTitle: logCategoriesTitle
    }
  }, rest), children);
};