"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sendIfDefined = void 0;
var _xstate = require("xstate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sendIfDefined = target => (eventExpr, options) => {
  return _xstate.actions.pure((context, event) => {
    const targetEvent = eventExpr(context, event);
    return targetEvent != null ? [_xstate.actions.send(targetEvent, {
      ...options,
      to: target
    })] : undefined;
  });
};
exports.sendIfDefined = sendIfDefined;