"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SteppedGradientLegendRT = exports.StepRuleRT = exports.StepLegendRT = exports.PALETTES = exports.OperatorRT = exports.LegendRT = exports.InventoryColorPaletteRT = exports.InfraWaffleMapRuleOperator = exports.InfraFormatterType = exports.GradientRuleRT = exports.GradientLegendRT = void 0;
var _i18n = require("@kbn/i18n");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OperatorRT = rt.keyof({
  gt: null,
  gte: null,
  lt: null,
  lte: null,
  eq: null
});
exports.OperatorRT = OperatorRT;
const PALETTES = {
  status: _i18n.i18n.translate('xpack.infra.legendControls.palettes.status', {
    defaultMessage: 'Status'
  }),
  temperature: _i18n.i18n.translate('xpack.infra.legendControls.palettes.temperature', {
    defaultMessage: 'Temperature'
  }),
  cool: _i18n.i18n.translate('xpack.infra.legendControls.palettes.cool', {
    defaultMessage: 'Cool'
  }),
  warm: _i18n.i18n.translate('xpack.infra.legendControls.palettes.warm', {
    defaultMessage: 'Warm'
  }),
  positive: _i18n.i18n.translate('xpack.infra.legendControls.palettes.positive', {
    defaultMessage: 'Positive'
  }),
  negative: _i18n.i18n.translate('xpack.infra.legendControls.palettes.negative', {
    defaultMessage: 'Negative'
  })
};
exports.PALETTES = PALETTES;
const InventoryColorPaletteRT = rt.keyof(PALETTES);
exports.InventoryColorPaletteRT = InventoryColorPaletteRT;
const StepRuleRT = rt.intersection([rt.type({
  value: rt.number,
  operator: OperatorRT,
  color: rt.string
}), rt.partial({
  label: rt.string
})]);
exports.StepRuleRT = StepRuleRT;
const StepLegendRT = rt.type({
  type: rt.literal('step'),
  rules: rt.array(StepRuleRT)
});
exports.StepLegendRT = StepLegendRT;
const GradientRuleRT = rt.type({
  value: rt.number,
  color: rt.string
});
exports.GradientRuleRT = GradientRuleRT;
const GradientLegendRT = rt.type({
  type: rt.literal('gradient'),
  rules: rt.array(GradientRuleRT)
});
exports.GradientLegendRT = GradientLegendRT;
const SteppedGradientLegendRT = rt.type({
  type: rt.literal('steppedGradient'),
  rules: rt.array(GradientRuleRT)
});
exports.SteppedGradientLegendRT = SteppedGradientLegendRT;
const LegendRT = rt.union([StepLegendRT, GradientLegendRT, SteppedGradientLegendRT]);
exports.LegendRT = LegendRT;
let InfraWaffleMapRuleOperator;
exports.InfraWaffleMapRuleOperator = InfraWaffleMapRuleOperator;
(function (InfraWaffleMapRuleOperator) {
  InfraWaffleMapRuleOperator["gt"] = "gt";
  InfraWaffleMapRuleOperator["gte"] = "gte";
  InfraWaffleMapRuleOperator["lt"] = "lt";
  InfraWaffleMapRuleOperator["lte"] = "lte";
  InfraWaffleMapRuleOperator["eq"] = "eq";
})(InfraWaffleMapRuleOperator || (exports.InfraWaffleMapRuleOperator = InfraWaffleMapRuleOperator = {}));
let InfraFormatterType;
exports.InfraFormatterType = InfraFormatterType;
(function (InfraFormatterType) {
  InfraFormatterType["number"] = "number";
  InfraFormatterType["abbreviatedNumber"] = "abbreviatedNumber";
  InfraFormatterType["bytes"] = "bytes";
  InfraFormatterType["bits"] = "bits";
  InfraFormatterType["percent"] = "percent";
})(InfraFormatterType || (exports.InfraFormatterType = InfraFormatterType = {}));