"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensAttributes = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _visualizations = require("../common/visualizations");
var _use_lazy_ref = require("./use_lazy_ref");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLensAttributes = ({
  type,
  dataView,
  options,
  visualizationType
}) => {
  const {
    services: {
      lens
    }
  } = (0, _public.useKibana)();
  const {
    navigateToPrefilledEditor
  } = lens;
  const {
    value,
    error
  } = (0, _useAsync.default)(lens.stateHelperApi, [lens]);
  const {
    formula: formulaAPI
  } = value !== null && value !== void 0 ? value : {};
  const lensChartConfig = _visualizations.hostLensFormulas[type];
  const Chart = _visualizations.visualizationTypes[visualizationType];
  const attributes = (0, _use_lazy_ref.useLazyRef)(() => {
    if (!dataView || !formulaAPI) {
      return null;
    }
    const builder = new _visualizations.LensAttributesBuilder(new Chart(lensChartConfig, dataView, formulaAPI, options));
    return builder.build();
  });
  const injectFilters = (0, _react.useCallback)(({
    filters,
    query = {
      language: 'kuery',
      query: ''
    }
  }) => {
    if (!attributes.current) {
      return null;
    }
    return {
      ...attributes.current,
      state: {
        ...attributes.current.state,
        query,
        filters: [...attributes.current.state.filters, ...filters]
      }
    };
  }, [attributes]);
  const openInLensAction = (0, _react.useCallback)(({
    timeRange,
    filters,
    query
  }) => () => {
    const injectedAttributes = injectFilters({
      filters,
      query
    });
    if (injectedAttributes) {
      navigateToPrefilledEditor({
        id: '',
        timeRange,
        attributes: injectedAttributes
      }, {
        openInNewTab: true
      });
    }
  }, [injectFilters, navigateToPrefilledEditor]);
  const getExtraActions = (0, _react.useCallback)(({
    timeRange,
    filters,
    query
  }) => {
    const openInLens = getOpenInLensAction(openInLensAction({
      timeRange,
      filters,
      query
    }));
    return [openInLens];
  }, [openInLensAction]);
  const {
    formula: {
      formula
    }
  } = lensChartConfig;
  return {
    formula,
    attributes: attributes.current,
    getExtraActions,
    error
  };
};
exports.useLensAttributes = useLensAttributes;
const getOpenInLensAction = onExecute => {
  return {
    id: 'openInLens',
    getDisplayName(_context) {
      return _i18n.i18n.translate('xpack.infra.hostsViewPage.tabs.metricsCharts.actions.openInLines', {
        defaultMessage: 'Open in Lens'
      });
    },
    getIconType(_context) {
      return 'visArea';
    },
    type: 'actionButton',
    async isCompatible(_context) {
      return true;
    },
    async execute(_context) {
      onExecute();
    },
    order: 100
  };
};