"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogTextStreamJumpToTail = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogTextStreamJumpToTail extends React.PureComponent {
  render() {
    const {
      onClickJump,
      width
    } = this.props;
    return /*#__PURE__*/React.createElement(JumpToTailWrapper, {
      width: width
    }, /*#__PURE__*/React.createElement(MessageWrapper, null, /*#__PURE__*/React.createElement(_eui.EuiText, {
      color: "subdued"
    }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.streamingNewEntriesText",
      defaultMessage: "Streaming new entries"
    }))), /*#__PURE__*/React.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "infraJumpToMostRecentEntriesButton",
      size: "xs",
      onClick: onClickJump,
      iconType: "arrowDown"
    }, /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logs.jumpToTailText",
      defaultMessage: "Jump to most recent entries"
    })));
  }
}
exports.LogTextStreamJumpToTail = LogTextStreamJumpToTail;
const JumpToTailWrapper = _common.euiStyled.div`
  align-items: center;
  display: flex;
  min-height: ${props => props.theme.eui.euiSizeXXL};
  width: ${props => props.width}px;
  position: fixed;
  bottom: 0;
  background-color: ${props => props.theme.eui.euiColorEmptyShade};
`;
const MessageWrapper = _common.euiStyled.div`
  padding: 8px 16px;
`;