"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogMinimap = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _d3Scale = require("d3-scale");
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _density_chart = require("./density_chart");
var _highlighted_interval = require("./highlighted_interval");
var _search_markers = require("./search_markers");
var _time_ruler = require("./time_ruler");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Wide enough to fit "September"
const TIMERULER_WIDTH = 50;
function calculateYScale(start, end, height) {
  return (0, _d3Scale.scaleLinear)().domain([start || 0, end || 0]).range([0, height]);
}
class LogMinimap extends React.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "handleClick", event => {
      const minimapTop = event.currentTarget.getBoundingClientRect().top;
      const clickedYPosition = event.clientY - minimapTop;
      const clickedTime = Math.floor(this.getYScale().invert(clickedYPosition));
      this.props.jumpToTarget({
        tiebreaker: 0,
        time: clickedTime
      });
    });
    (0, _defineProperty2.default)(this, "getYScale", () => {
      const {
        start,
        end,
        height
      } = this.props;
      return calculateYScale(start, end, height);
    });
    (0, _defineProperty2.default)(this, "getPositionOfTime", time => {
      var _this$getYScale;
      return (_this$getYScale = this.getYScale()(time)) !== null && _this$getYScale !== void 0 ? _this$getYScale : 0;
    });
    (0, _defineProperty2.default)(this, "updateTimeCursor", event => {
      const svgPosition = event.currentTarget.getBoundingClientRect();
      const timeCursorY = event.clientY - svgPosition.top;
      this.setState({
        timeCursorY
      });
    });
    this.state = {
      timeCursorY: 0,
      target: props.target
    };
  }
  render() {
    const {
      start,
      end,
      className,
      height,
      highlightedInterval,
      jumpToTarget,
      summaryBuckets,
      summaryHighlightBuckets,
      width
    } = this.props;
    const {
      timeCursorY,
      target
    } = this.state;
    const [minTime, maxTime] = calculateYScale(start, end, height).domain();
    const tickCount = height ? Math.floor(height / 50) : 12;
    return /*#__PURE__*/React.createElement(MinimapWrapper, {
      className: className,
      height: height,
      preserveAspectRatio: "none",
      viewBox: `0 0 ${width} ${height}`,
      width: width,
      onClick: this.handleClick,
      onMouseMove: this.updateTimeCursor
    }, /*#__PURE__*/React.createElement(MinimapBorder, {
      x1: TIMERULER_WIDTH,
      x2: TIMERULER_WIDTH,
      y1: 0,
      y2: height
    }), /*#__PURE__*/React.createElement(_time_ruler.TimeRuler, {
      start: minTime,
      end: maxTime,
      width: TIMERULER_WIDTH,
      height: height,
      tickCount: tickCount
    }), /*#__PURE__*/React.createElement("g", {
      transform: `translate(${TIMERULER_WIDTH}, 0)`
    }, /*#__PURE__*/React.createElement(_density_chart.DensityChart, {
      buckets: summaryBuckets,
      start: minTime,
      end: maxTime,
      width: width - TIMERULER_WIDTH,
      height: height
    }), /*#__PURE__*/React.createElement(_search_markers.SearchMarkers, {
      buckets: summaryHighlightBuckets || [],
      start: minTime,
      end: maxTime,
      width: width - TIMERULER_WIDTH,
      height: height,
      jumpToTarget: jumpToTarget
    })), highlightedInterval ? /*#__PURE__*/React.createElement(_highlighted_interval.HighlightedInterval, {
      end: highlightedInterval.end,
      getPositionOfTime: this.getPositionOfTime,
      start: highlightedInterval.start,
      targetWidth: TIMERULER_WIDTH,
      width: width,
      target: target
    }) : null, /*#__PURE__*/React.createElement(TimeCursor, {
      x1: TIMERULER_WIDTH,
      x2: width,
      y1: timeCursorY,
      y2: timeCursorY
    }));
  }
}
exports.LogMinimap = LogMinimap;
const MinimapBorder = _common.euiStyled.line`
  stroke: ${props => props.theme.eui.euiColorMediumShade};
  stroke-width: 1px;
`;
const TimeCursor = _common.euiStyled.line`
  pointer-events: none;
  stroke-width: 1px;
  stroke: ${props => props.theme.darkMode ? props.theme.eui.euiColorDarkestShade : props.theme.eui.euiColorDarkShade};
`;
const MinimapWrapper = _common.euiStyled.svg`
  cursor: pointer;
  fill: ${props => props.theme.eui.euiColorEmptyShade};
  & ${TimeCursor} {
    visibility: hidden;
  }
  &:hover ${TimeCursor} {
    visibility: visible;
  }
`;