"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatasetsSelector = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _log_analysis = require("../../../../common/log_analysis");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatasetsSelector = ({
  availableDatasets,
  isLoading = false,
  onChangeDatasetSelection,
  selectedDatasets
}) => {
  const options = (0, _react.useMemo)(() => availableDatasets.map(dataset => ({
    value: dataset,
    label: (0, _log_analysis.getFriendlyNameForPartitionId)(dataset)
  })), [availableDatasets]);
  const selectedOptions = (0, _react.useMemo)(() => options.filter(({
    value
  }) => value != null && selectedDatasets.includes(value)), [options, selectedDatasets]);
  const handleChange = (0, _react.useCallback)(newSelectedOptions => onChangeDatasetSelection(newSelectedOptions.map(({
    value
  }) => value).filter(isDefined)), [onChangeDatasetSelection]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "aria-label": datasetFilterPlaceholder,
    isLoading: isLoading,
    onChange: handleChange,
    options: options,
    placeholder: datasetFilterPlaceholder,
    selectedOptions: selectedOptions
  });
};
exports.DatasetsSelector = DatasetsSelector;
const datasetFilterPlaceholder = _i18n.i18n.translate('xpack.infra.logs.analysis.datasetFilterPlaceholder', {
  defaultMessage: 'Filter by datasets'
});
const isDefined = value => value != null;