"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsTableNoIndicesContent = exports.MetricsTableLoadingContent = exports.MetricsTableEmptyIndicesContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _empty_states = require("../../../empty_states");
var _no_results_dark = _interopRequireDefault(require("./assets/no_results_dark.svg"));
var _no_results_light = _interopRequireDefault(require("./assets/no_results_light.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricsTableLoadingContent = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  "data-test-subj": "metricsTableLoadingContent",
  icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    logo: "logoMetrics",
    size: "xl"
  }),
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.metricsTable.loadingContentTitle",
    defaultMessage: "Loading metrics"
  }))
});
exports.MetricsTableLoadingContent = MetricsTableLoadingContent;
const MetricsTableNoIndicesContent = () => {
  const integrationsLinkProps = (0, _public.useLinkProps)({
    app: 'integrations',
    pathname: 'browse'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "metricsTableLoadingContent",
    iconType: "logoMetrics",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _empty_states.noMetricIndicesPromptTitle),
    body: /*#__PURE__*/_react.default.createElement("p", null, _empty_states.noMetricIndicesPromptDescription),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      "data-test-subj": "infraMetricsTableNoIndicesContentButton",
      color: "primary",
      fill: true
    }, integrationsLinkProps), _empty_states.noMetricIndicesPromptPrimaryActionTitle)
  });
};
exports.MetricsTableNoIndicesContent = MetricsTableNoIndicesContent;
const MetricsTableEmptyIndicesContent = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metricsTable.emptyIndicesPromptTimeRangeHintTitle",
      defaultMessage: "Expand your time range"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metricsTable.emptyIndicesPromptTimeRangeHintDescription",
      defaultMessage: "Try searching over a longer period of time."
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metricsTable.emptyIndicesPromptQueryHintTitle",
      defaultMessage: "Adjust your query"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metricsTable.emptyIndicesPromptQueryHintDescription",
      defaultMessage: "Try searching for a different combination of terms."
    }))),
    color: "subdued",
    "data-test-subj": "metricsTableEmptyIndicesContent",
    icon: /*#__PURE__*/_react.default.createElement(NoResultsIllustration, null),
    layout: "horizontal",
    title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metricsTable.emptyIndicesPromptTitle",
      defaultMessage: "No results match your search criteria"
    })),
    titleSize: "m"
  });
};
exports.MetricsTableEmptyIndicesContent = MetricsTableEmptyIndicesContent;
const NoResultsIllustration = () => {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const illustration = colorMode === _eui.COLOR_MODES_STANDARD.dark ? _no_results_dark.default : _no_results_light.default;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: noResultsIllustrationAlternativeText,
    size: "fullWidth",
    src: illustration
  });
};
const noResultsIllustrationAlternativeText = _i18n.i18n.translate('xpack.infra.metricsTable.noResultsIllustrationAlternativeText', {
  defaultMessage: 'A magnifying glass with an exclamation mark'
});