"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Logs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _log_views = require("../../../../../common/log_views");
var _use_kibana = require("../../../../hooks/use_kibana");
var _log_stream = require("../../../log_stream");
var _inventory_models = require("../../../../../common/inventory_models");
var _loading = require("../../../loading");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TEXT_QUERY_THROTTLE_INTERVAL_MS = 500;
const Logs = ({
  nodeName,
  currentTime,
  nodeType,
  logViewReference,
  search,
  logViewLoading = false,
  onSearchChange
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    locators
  } = services;
  const [textQuery, setTextQuery] = (0, _react.useState)(search !== null && search !== void 0 ? search : '');
  const [textQueryDebounced, setTextQueryDebounced] = (0, _react.useState)(search !== null && search !== void 0 ? search : '');
  const startTimestamp = currentTime - 60 * 60 * 1000; // 60 minutes

  (0, _useDebounce.default)(() => {
    if (onSearchChange) {
      onSearchChange(textQuery);
    }
    setTextQueryDebounced(textQuery);
  }, TEXT_QUERY_THROTTLE_INTERVAL_MS, [textQuery]);
  const filter = (0, _react.useMemo)(() => {
    const query = [`${(0, _inventory_models.findInventoryFields)(nodeType).id}: "${nodeName}"`, ...(textQueryDebounced !== '' ? [textQueryDebounced] : [])].join(' and ');
    return {
      language: 'kuery',
      query
    };
  }, [nodeType, nodeName, textQueryDebounced]);
  const onQueryChange = (0, _react.useCallback)(e => {
    setTextQuery(e.target.value);
  }, []);
  const logView = (0, _react.useMemo)(() => logViewReference ? logViewReference : _log_views.DEFAULT_LOG_VIEW, [logViewReference]);
  const logsUrl = (0, _react.useMemo)(() => {
    return locators.nodeLogsLocator.getRedirectUrl({
      nodeType,
      nodeId: nodeName,
      time: startTimestamp,
      filter: textQueryDebounced,
      logView
    });
  }, [locators.nodeLogsLocator, nodeName, nodeType, startTimestamp, textQueryDebounced, logView]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    "data-test-subj": "infraAssetDetailsLogsTabContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "infraAssetDetailsLogsTabFieldSearch",
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.infra.nodeDetails.logs.textFieldPlaceholder', {
      defaultMessage: 'Search for log entries...'
    }),
    value: textQuery,
    isClearable: true,
    onChange: onQueryChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: services
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraAssetDetailsLogsTabOpenInLogsButton",
    size: "xs",
    flush: "both",
    iconType: "popout",
    href: logsUrl
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.nodeDetails.logs.openLogsLink",
    defaultMessage: "Open in Logs"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, logViewLoading || !logViewReference ? /*#__PURE__*/_react.default.createElement(_loading.InfraLoadingPanel, {
    width: "100%",
    height: "60vh",
    text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.hostsViewPage.tabs.logs.loadingEntriesLabel",
      defaultMessage: "Loading entries"
    })
  }) : /*#__PURE__*/_react.default.createElement(_log_stream.LogStream, {
    logView: logView,
    startTimestamp: startTimestamp,
    endTimestamp: currentTime,
    query: filter,
    height: "60vh",
    showFlyoutAction: true
  })));
};
exports.Logs = Logs;