"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabToApmTraces = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabToApmTraces = ({
  nodeName,
  apmField,
  name,
  ...props
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const apmTracesMenuItemLinkProps = (0, _public.useLinkProps)({
    app: 'apm',
    hash: 'traces',
    search: {
      kuery: `${apmField}:"${nodeName}"`
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({}, props, apmTracesMenuItemLinkProps, {
    "data-test-subj": "hostsView-flyout-apm-services-link"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "popout",
    css: (0, _react2.css)`
          margin-right: ${euiTheme.size.xs};
        `
  }), name);
};
exports.TabToApmTraces = TabToApmTraces;