"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DecorateWithKibanaContext = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _rxjs = require("rxjs");
var _addonActions = require("@storybook/addon-actions");
var _addons = require("@storybook/addons");
var _metrics_source = require("../../../containers/metrics_source");
var _http = require("./context/http");
var _fixtures = require("./context/fixtures");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const settings = {
  'dateFormat:scaled': [['', 'HH:mm:ss.SSS']]
};
const getSettings = key => settings[key];
const DecorateWithKibanaContext = story => {
  const initialProcesses = (0, _addons.useParameter)('apiResponse', {
    mock: 'default'
  });
  const mockServices = {
    application: {
      currentAppId$: (0, _rxjs.of)('infra'),
      navigateToUrl: async url => {
        (0, _addonActions.action)(`Navigate to: ${url}`);
      },
      getUrlForApp: url => url
    },
    data: {
      search: {
        search: (request, options) => {
          return (0, _fixtures.getLogEntries)(request, options);
        }
      },
      query: {
        filterManager: {
          addFilters: () => {},
          removeFilter: () => {}
        }
      }
    },
    locators: {
      nodeLogsLocator: {
        getRedirectUrl: () => {
          return '';
        }
      }
    },
    uiActions: {
      getTriggerCompatibleActions: () => {
        return Promise.resolve([]);
      }
    },
    settings: {
      client: {
        get$: key => (0, _rxjs.of)(getSettings(key)),
        get: getSettings
      }
    },
    notifications: {
      toasts: {
        add: params => {
          (0, _addonActions.action)('notifications.toats.add')(params);
          return {
            id: 'id'
          };
        }
      }
    },
    http: (0, _http.getHttp)(initialProcesses),
    share: {
      url: {
        locators: {
          get: _id => ({
            navigate: async () => {
              return Promise.resolve();
            }
          })
        }
      }
    }
  };
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: mockServices
  }, /*#__PURE__*/_react.default.createElement(_metrics_source.SourceProvider, {
    sourceId: "default"
  }, story())));
};
exports.DecorateWithKibanaContext = DecorateWithKibanaContext;