"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricChart = void 0;
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HISTOGRAM_COLUMN_NAME = 'x_date_histogram';
const TRENDLINE_LAYER_ID = 'trendline_layer';
const TRENDLINE_ACCESSOR = 'metric_trendline_formula_accessor';
const ACCESSOR = 'metric_formula_accessor';
class MetricChart {
  constructor(chartConfig, dataView, formulaAPI, options) {
    this.chartConfig = chartConfig;
    this.dataView = dataView;
    this.formulaAPI = formulaAPI;
    this.options = options;
  }
  getVisualizationType() {
    return 'lnsMetric';
  }
  getTrendLineLayer(baseLayer) {
    const trendLineLayer = this.formulaAPI.insertOrReplaceFormulaColumn(TRENDLINE_ACCESSOR, this.getFormulaWithOverride(), baseLayer, this.dataView);
    if (!trendLineLayer) {
      throw new Error('Error generating the data layer for the chart');
    }
    return {
      [TRENDLINE_LAYER_ID]: {
        linkToLayers: [_utils.DEFAULT_LAYER_ID],
        ...trendLineLayer
      }
    };
  }
  getFormulaWithOverride() {
    var _formula$format, _formula$format$param, _this$options;
    const {
      formula
    } = this.chartConfig;
    const {
      decimals = (_formula$format = formula.format) === null || _formula$format === void 0 ? void 0 : (_formula$format$param = _formula$format.params) === null || _formula$format$param === void 0 ? void 0 : _formula$format$param.decimals,
      title = this.chartConfig.title
    } = (_this$options = this.options) !== null && _this$options !== void 0 ? _this$options : {};
    return {
      ...this.chartConfig.formula,
      ...(formula.format && decimals ? {
        format: {
          ...formula.format,
          params: {
            decimals
          }
        }
      } : {}),
      label: title
    };
  }
  getLayers() {
    var _this$options2;
    const {
      showTrendLine = true
    } = (_this$options2 = this.options) !== null && _this$options2 !== void 0 ? _this$options2 : {};
    const baseLayer = {
      columnOrder: [HISTOGRAM_COLUMN_NAME],
      columns: (0, _utils.getHistogramColumn)({
        columnName: HISTOGRAM_COLUMN_NAME,
        overrides: {
          sourceField: this.dataView.timeFieldName,
          params: {
            interval: 'auto',
            includeEmptyRows: true
          }
        }
      }),
      sampling: 1
    };
    const baseLayerDetails = this.formulaAPI.insertOrReplaceFormulaColumn(ACCESSOR, this.getFormulaWithOverride(), {
      columnOrder: [],
      columns: {}
    }, this.dataView);
    if (!baseLayerDetails) {
      throw new Error('Error generating the data layer for the chart');
    }
    return {
      [_utils.DEFAULT_LAYER_ID]: baseLayerDetails,
      ...(showTrendLine ? this.getTrendLineLayer(baseLayer) : {})
    };
  }
  getVisualizationState() {
    var _this$options3;
    const {
      subtitle,
      backgroundColor,
      showTrendLine = true
    } = (_this$options3 = this.options) !== null && _this$options3 !== void 0 ? _this$options3 : {};
    return {
      layerId: _utils.DEFAULT_LAYER_ID,
      layerType: 'data',
      metricAccessor: ACCESSOR,
      color: backgroundColor,
      subtitle,
      showBar: false,
      ...(showTrendLine ? {
        trendlineLayerId: TRENDLINE_LAYER_ID,
        trendlineLayerType: 'metricTrendline',
        trendlineMetricAccessor: TRENDLINE_ACCESSOR,
        trendlineTimeAccessor: HISTOGRAM_COLUMN_NAME
      } : {})
    };
  }
  getReferences() {
    var _this$options4;
    const {
      showTrendLine = true
    } = (_this$options4 = this.options) !== null && _this$options4 !== void 0 ? _this$options4 : {};
    return [...(0, _utils.getDefaultReferences)(this.dataView, _utils.DEFAULT_LAYER_ID), ...(showTrendLine ? (0, _utils.getDefaultReferences)(this.dataView, TRENDLINE_LAYER_ID) : [])];
  }
  getDataView() {
    return this.dataView;
  }
  getTitle() {
    var _this$options5, _this$options$title, _this$options6;
    return (_this$options5 = this.options) !== null && _this$options5 !== void 0 && _this$options5.showTitle ? (_this$options$title = (_this$options6 = this.options) === null || _this$options6 === void 0 ? void 0 : _this$options6.title) !== null && _this$options$title !== void 0 ? _this$options$title : this.chartConfig.title : '';
  }
  getFilters() {
    var _this$dataView$id;
    return this.chartConfig.getFilters({
      id: (_this$dataView$id = this.dataView.id) !== null && _this$dataView$id !== void 0 ? _this$dataView$id : _utils.DEFAULT_LAYER_ID
    });
  }
}
exports.MetricChart = MetricChart;