"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diskReadThroughput = void 0;
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const diskReadThroughput = {
  title: 'Disk Read Throughput',
  formula: {
    formula: "counter_rate(max(system.diskio.read.count), kql='system.diskio.read.count: *')",
    format: {
      id: 'bytes',
      params: {
        decimals: 1
      }
    }
  },
  getFilters: _utils.getFilters
};
exports.diskReadThroughput = diskReadThroughput;