"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLocationToDiscover = exports.createSearchString = exports.createNodeLogsQuery = void 0;
var _lodash = require("lodash");
var _inventory_models = require("../inventory_models");
var _constants = require("../constants");
var _log_views = require("../log_views");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createNodeLogsQuery = params => {
  const {
    nodeType,
    nodeId,
    filter
  } = params;
  const nodeFilter = `${(0, _inventory_models.findInventoryFields)(nodeType).id}: ${nodeId}`;
  const query = filter ? `(${nodeFilter}) and (${filter})` : nodeFilter;
  return query;
};
exports.createNodeLogsQuery = createNodeLogsQuery;
const createSearchString = ({
  time,
  timeRange,
  filter = '',
  logView = _log_views.DEFAULT_LOG_VIEW
}) => {
  return (0, _lodash.flowRight)((0, _log_views.replaceLogFilterInQueryString)({
    language: 'kuery',
    query: filter
  }, time, timeRange), (0, _log_views.replaceLogPositionInQueryString)(time), (0, _log_views.replaceLogViewInQueryString)(logView))('');
};
exports.createSearchString = createSearchString;
const getLocationToDiscover = async ({
  core,
  timeRange,
  filter,
  logView = _log_views.DEFAULT_LOG_VIEW
}) => {
  const [, plugins, pluginStart] = await core.getStartServices();
  const {
    discover
  } = plugins;
  const {
    logViews
  } = pluginStart;
  const resolvedLogView = await logViews.client.getResolvedLogView(logView);
  const discoverParams = {
    ...(timeRange ? {
      from: timeRange.startTime,
      to: timeRange.endTime
    } : {}),
    ...(filter ? {
      query: {
        language: 'kuery',
        query: filter
      }
    } : {})
  };
  const discoverLocation = await constructDiscoverLocation(discover, discoverParams, resolvedLogView);
  if (!discoverLocation) {
    throw new Error('Discover location not found');
  }
  return discoverLocation;
};
exports.getLocationToDiscover = getLocationToDiscover;
const constructDiscoverLocation = async (discover, discoverParams, resolvedLogView) => {
  var _discover$locator2;
  if (!resolvedLogView) {
    var _discover$locator;
    return await ((_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.getLocation(discoverParams));
  }
  const columns = parseColumns(resolvedLogView.columns);
  const dataViewSpec = resolvedLogView.dataViewReference.toSpec();
  return await ((_discover$locator2 = discover.locator) === null || _discover$locator2 === void 0 ? void 0 : _discover$locator2.getLocation({
    ...discoverParams,
    columns,
    dataViewId: dataViewSpec.id,
    dataViewSpec
  }));
};
const parseColumns = columns => {
  return columns.map(getColumnValue).filter(Boolean);
};
const getColumnValue = column => {
  if ('messageColumn' in column) return _constants.MESSAGE_FIELD;
  if ('timestampColumn' in column) return _constants.TIMESTAMP_FIELD;
  if ('fieldColumn' in column) return column.fieldColumn.field;
  return null;
};