"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateIndexSettingsSuccess = exports.updateIndexSettingsError = exports.updateIndexSettings = void 0;
var _reduxActions = require("redux-actions");
var _i18n = require("@kbn/i18n");
var _services = require("../../services");
var _reload_indices = require("./reload_indices");
var _notification = require("../../services/notification");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateIndexSettingsSuccess = (0, _reduxActions.createAction)('INDEX_MANAGEMENT_UPDATE_INDEX_SETTINGS_SUCCESS');
exports.updateIndexSettingsSuccess = updateIndexSettingsSuccess;
const updateIndexSettingsError = (0, _reduxActions.createAction)('INDEX_MANAGEMENT_UPDATE_INDEX_SETTINGS_ERROR');
exports.updateIndexSettingsError = updateIndexSettingsError;
const updateIndexSettings = ({
  indexName,
  settings
}) => async dispatch => {
  if (Object.keys(settings).length !== 0) {
    const {
      error
    } = await (0, _services.updateIndexSettings)(indexName, settings);
    if (error) {
      return dispatch(updateIndexSettingsError({
        error: error.message
      }));
    }
  }
  dispatch(updateIndexSettingsSuccess());
  dispatch((0, _reload_indices.reloadIndices)([indexName]));
  _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.updateIndexSettingsAction.settingsSuccessUpdateMessage', {
    defaultMessage: 'Successfully updated settings for index {indexName}',
    values: {
      indexName
    }
  }));
};
exports.updateIndexSettings = updateIndexSettings;