"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editIndexSettings = void 0;
var _i18n = require("@kbn/i18n");
var _services = require("../../services");
var _notification = require("../../services/notification");
var _load_index_data = require("./load_index_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const editIndexSettings = ({
  indexName
}) => async dispatch => {
  let indexSettings;
  try {
    indexSettings = await (0, _services.loadIndexSettings)(indexName);
  } catch (error) {
    return _notification.notificationService.showDangerToast(error.message);
  }
  _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.editIndexSettingsAction.successfullySavedSettingsForIndicesMessage', {
    defaultMessage: 'Successfully saved settings for {indexName}',
    values: {
      indexName
    }
  }));
  dispatch((0, _load_index_data.loadIndexDataSuccess)({
    data: indexSettings,
    panelType: 'editIndexSettings',
    indexName
  }));
};
exports.editIndexSettings = editIndexSettings;