"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.clearCacheIndicesStart = exports.clearCacheIndices = void 0;
var _reduxActions = require("redux-actions");
var _i18n = require("@kbn/i18n");
var _services = require("../../services");
var _notification = require("../../services/notification");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const clearCacheIndicesStart = (0, _reduxActions.createAction)('INDEX_MANAGEMENT_CLEAR_CACHE_INDICES_START');
exports.clearCacheIndicesStart = clearCacheIndicesStart;
const clearCacheIndices = ({
  indexNames
}) => async dispatch => {
  dispatch(clearCacheIndicesStart({
    indexNames
  }));
  try {
    await (0, _services.clearCacheIndices)(indexNames);
  } catch (error) {
    _notification.notificationService.showDangerToast(error.message);
    return dispatch((0, _.clearRowStatus)({
      indexNames
    }));
  }
  dispatch((0, _.reloadIndices)(indexNames));
  _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.clearCacheIndicesAction.successMessage', {
    defaultMessage: 'Successfully cleared cache: [{indexNames}]',
    values: {
      indexNames: indexNames.join(', ')
    }
  }));
};
exports.clearCacheIndices = clearCacheIndices;