"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _breadcrumbs = require("../../services/breadcrumbs");
var _api = require("../../services/api");
var _routing = require("../../services/routing");
var _components = require("../../components");
var _index_templates = require("../../lib/index_templates");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TemplateEdit = ({
  match: {
    params: {
      name
    }
  },
  location,
  history
}) => {
  const decodedTemplateName = (0, _shared_imports.attemptToURIDecode)(name);
  const isLegacy = (0, _index_templates.getIsLegacyFromQueryParams)(location);
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const {
    error,
    data: template,
    isLoading
  } = (0, _api.useLoadIndexTemplate)(decodedTemplateName, isLegacy);
  (0, _react.useEffect)(() => {
    _breadcrumbs.breadcrumbService.setBreadcrumbs('templateEdit');
  }, []);
  const onSave = async updatedTemplate => {
    setIsSaving(true);
    setSaveError(null);
    const {
      error: saveErrorObject
    } = await (0, _api.updateTemplate)(updatedTemplate);
    setIsSaving(false);
    if (saveErrorObject) {
      setSaveError(saveErrorObject);
      return;
    }
    history.push((0, _routing.getTemplateDetailsLink)(decodedTemplateName, updatedTemplate._kbnMeta.isLegacy));
  };
  const clearSaveError = () => {
    setSaveError(null);
  };
  let isSystemTemplate;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateEdit.loadingIndexTemplateDescription",
      defaultMessage: "Loading template\u2026"
    }));
  } else if (error) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateEdit.loadingIndexTemplateErrorMessage",
        defaultMessage: "Error loading template"
      }),
      error: error,
      "data-test-subj": "sectionError"
    });
  } else if (template) {
    const {
      name: templateName,
      _kbnMeta: {
        type
      }
    } = template;
    isSystemTemplate = templateName && templateName.startsWith('.');
    if (type === 'cloudManaged') {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.PageError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.templateEdit.managedTemplateWarningTitle",
          defaultMessage: "Editing a managed template is not permitted"
        }),
        error: {
          message: _i18n.i18n.translate('xpack.idxMgmt.templateEdit.managedTemplateWarningDescription', {
            defaultMessage: 'Managed templates are critical for internal operations.'
          })
        },
        "data-test-subj": "systemTemplateEditCallout"
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContentBody_Deprecated, {
    restrictWidth: true,
    style: {
      width: '100%'
    }
  }, isSystemTemplate && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateEdit.systemTemplateWarningTitle",
      defaultMessage: "Editing a system template can break Kibana"
    }),
    color: "danger",
    iconType: "warning",
    "data-test-subj": "systemTemplateEditCallout"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.templateEdit.systemTemplateWarningDescription",
    defaultMessage: "System templates are critical for internal operations."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_components.TemplateForm, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.editTemplate.editTemplatePageTitle",
      defaultMessage: "Edit template '{name}'",
      values: {
        name: decodedTemplateName
      }
    }),
    defaultValue: template,
    onSave: onSave,
    isSaving: isSaving,
    saveError: saveError,
    clearSaveError: clearSaveError,
    isEditing: true,
    isLegacy: isLegacy,
    history: history
  }));
};
exports.TemplateEdit = TemplateEdit;