"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditSettingsJson = void 0;
var _reactRedux = require("react-redux");
var _edit_settings_json = require("./edit_settings_json");
var _actions = require("../../../../../store/actions");
var _selectors = require("../../../../../store/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  const indexName = (0, _selectors.getDetailPanelIndexName)(state);
  return {
    error: (0, _selectors.getDetailPanelError)(state),
    data: (0, _selectors.getDetailPanelData)(state),
    indexName,
    indexStatus: (0, _selectors.getIndexStatusByIndexName)(state, indexName)
  };
};
const mapDispatchToProps = {
  loadIndexData: _actions.loadIndexData,
  closeDetailPanel: _actions.closeDetailPanel,
  updateIndexSettings: _actions.updateIndexSettings
};
const EditSettingsJson = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_edit_settings_json.EditSettingsJson);
exports.EditSettingsJson = EditSettingsJson;