"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getIsLegacyFromQueryParams = void 0;
var _queryString = require("query-string");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIsLegacyFromQueryParams = location => {
  const {
    legacy
  } = (0, _queryString.parse)(location.search.substring(1));
  if (!Boolean(legacy) || typeof legacy !== 'string') {
    return false;
  }
  return legacy === 'true';
};
exports.getIsLegacyFromQueryParams = getIsLegacyFromQueryParams;